/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.data;

import java.util.Collections;
import java.util.Set;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class IgniteDialect
extends AbstractDialect {
    public static final IgniteDialect INSTANCE = new IgniteDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
        }

        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    static final LockClause LOCK_CLAUSE = new LockClause(){

        public String getLock(LockOptions lockOptions) {
            return "";
        }

        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    };
    private final IgniteArrayColumns arrayColumns = new IgniteArrayColumns();

    private IgniteDialect() {
    }

    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    public ArrayColumns getArraySupport() {
        return this.arrayColumns;
    }

    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.create((IdentifierProcessing.Quoting)IdentifierProcessing.Quoting.ANSI, (IdentifierProcessing.LetterCasing)IdentifierProcessing.LetterCasing.UPPER_CASE);
    }

    public Set<Class<?>> simpleTypes() {
        return Collections.emptySet();
    }

    public boolean supportsSingleQueryLoading() {
        return false;
    }

    static class IgniteArrayColumns
    implements ArrayColumns {
        IgniteArrayColumns() {
        }

        public boolean isSupported() {
            return true;
        }

        public Class<?> getArrayType(Class<?> userType) {
            Assert.notNull(userType, (String)"Array component type must not be null");
            return ClassUtils.resolvePrimitiveIfNecessary(userType);
        }
    }
}

