/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import org.apache.ignite.IgniteClientProperties;
import org.apache.ignite.IgniteClientPropertiesCustomizer;
import org.apache.ignite.SslConfigurationProperties;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.SslConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={IgniteClient.class})
@EnableConfigurationProperties(value={IgniteClientProperties.class})
public class IgniteClientAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public IgniteClientPropertiesCustomizer customizer() {
        return cfg -> {};
    }

    @Bean
    public IgniteClient createIgniteClient(IgniteClientProperties config, IgniteClientPropertiesCustomizer clientCustomizer) {
        SslConfigurationProperties sslConfig;
        clientCustomizer.accept(config);
        IgniteClient.Builder builder = IgniteClient.builder();
        if (config.getAddresses() != null) {
            builder.addresses(config.getAddresses());
        }
        if (config.getConnectTimeout() != null) {
            builder.connectTimeout(config.getConnectTimeout().longValue());
        }
        if (config.isMetricsEnabled() != null) {
            builder.metricsEnabled(config.isMetricsEnabled().booleanValue());
        }
        if (config.getSslConfiguration() != null && (sslConfig = config.getSslConfiguration()).enabled()) {
            builder.ssl((SslConfiguration)sslConfig);
        }
        if (config.getBackgroundReconnectInterval() != null) {
            builder.backgroundReconnectInterval(config.getBackgroundReconnectInterval().longValue());
        }
        if (config.getHeartbeatInterval() != null) {
            builder.heartbeatInterval(config.getHeartbeatInterval().longValue());
        }
        if (config.getHeartbeatTimeout() != null) {
            builder.heartbeatTimeout(config.getHeartbeatTimeout().longValue());
        }
        if (config.getOperationTimeout() != null) {
            builder.operationTimeout(config.getOperationTimeout().longValue());
        }
        return builder.build();
    }
}

