/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.marshallers;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.SuperMethodCall;

public final class ForeignObjectInputStream
extends ObjectInputStream {
    private final List<Class<?>> dummyClasses;
    private final ClassLoader publicClassloader;

    public ForeignObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.dummyClasses = new ArrayList();
        this.publicClassloader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class c;
        try {
            c = super.resolveClass(desc);
        }
        catch (ClassNotFoundException ex) {
            String className = desc.getName();
            if (!className.startsWith("org.apache.ignite.")) {
                throw ex;
            }
            c = new ByteBuddy().subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(className).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PRIVATE}).intercept((Implementation)SuperMethodCall.INSTANCE.andThen(MethodCall.run(() -> {
                throw new RuntimeException(String.format("Cannot instantiate dummy object for class '%s'. This class could not be found and a placeholder was generated.", className));
            }))).make().load(this.publicClassloader, (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
            this.dummyClasses.add(c);
        }
        return c;
    }

    @Override
    protected Object resolveObject(Object obj) {
        for (Class<?> klass : this.dummyClasses) {
            if (!klass.isInstance(obj)) continue;
            throw new IllegalStateException("Found instance of dummy object: " + klass.getName());
        }
        return obj;
    }
}

