/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.marshallers;

import java.io.InputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.migrationtools.persistence.marshallers.ForeignObjectInputStream;
import org.jetbrains.annotations.Nullable;

public class ForeignJdkMarshaller
extends JdkMarshaller {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T unmarshal0(InputStream in, @Nullable ClassLoader clsLdr) throws IgniteCheckedException {
        assert (in != null);
        ClassLoader localClassLoader = clsLdr != null ? clsLdr : ((Object)((Object)this)).getClass().getClassLoader();
        try (ForeignObjectInputStream objIn = new ForeignObjectInputStream(in, localClassLoader);){
            Object object = objIn.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException e) {
            throw new IgniteCheckedException("Failed to find class with given class loader for unmarshalling [clsLdr=" + localClassLoader + ", cls=" + e.getMessage() + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to deserialize object with given class loader: " + localClassLoader, (Throwable)e);
        }
    }
}

