/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.maintenance.MaintenanceProcessor;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.deployment.GridDeploymentManager;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.managers.indexing.GridIndexingManager;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.processors.affinity.GridAffinityProcessor;
import org.apache.ignite.internal.processors.authentication.IgniteAuthenticationProcessor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneNoopCommunicationSpi;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneNoopDiscoverySpi;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.processors.continuous.GridContinuousProcessor;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.platform.PlatformNoopProcessor;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.processors.port.GridPortProcessor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.processors.security.NoOpIgniteSecurityProcessor;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.stat.IoStatisticsManager;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.migrationtools.persistence.LoggerBridge;
import org.apache.ignite.migrationtools.persistence.MigrationCacheProcessor;
import org.apache.ignite.migrationtools.persistence.MigrationKernal;
import org.apache.ignite.migrationtools.persistence.MigrationNodeFolderResolver;
import org.apache.ignite.migrationtools.persistence.marshallers.ForeignJdkMarshaller;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.deployment.DeploymentSpi;
import org.apache.ignite.spi.deployment.local.LocalDeploymentSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.spi.eventstorage.EventStorageSpi;
import org.apache.ignite.spi.eventstorage.NoopEventStorageSpi;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.spi.indexing.noop.NoopIndexingSpi;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.noop.NoopMetricExporterSpi;
import org.apache.ignite.spi.systemview.SystemViewExporterSpi;

public class MigrationKernalContext
extends GridKernalContextImpl {
    private static final Field CFG_FIELD;
    private static final Field GRID_FIELD;
    private static final Field MARSH_CTX_FIELD;
    private static final Field JDK_MARSHALLER_FIELD;
    private static final Field IO_STATS_MANAGER;
    private boolean isStarted;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public MigrationKernalContext(IgniteConfiguration cfg, File nodeFolder, Serializable nodeConsistentId) throws IgniteCheckedException {
        List<String> errors = MigrationKernalContext.validateConfigurations(cfg);
        if (!errors.isEmpty()) {
            throw new IgniteCheckedException("Error validating ignite configuration: " + errors);
        }
        this.isStarted = false;
        IgniteUtils.IGNITE_MBEANS_DISABLED = true;
        MarshallerContextImpl marshCtx = new MarshallerContextImpl(null, null);
        BinaryMarshaller binaryMarsh = new BinaryMarshaller();
        binaryMarsh.setContext((MarshallerContext)marshCtx);
        IgniteConfiguration adaptedConfiguration = MigrationKernalContext.adaptConfiguration(cfg, nodeFolder, nodeConsistentId, binaryMarsh);
        try {
            CFG_FIELD.set((Object)this, adaptedConfiguration);
            JDK_MARSHALLER_FIELD.set(marshCtx, (Object)new ForeignJdkMarshaller());
            MARSH_CTX_FIELD.set((Object)this, marshCtx);
            IO_STATS_MANAGER.set((Object)this, new IoStatisticsManager());
            GRID_FIELD.set((Object)this, (Object)MigrationKernal.create((GridKernalContext)this, adaptedConfiguration));
        }
        catch (IllegalAccessException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        marshCtx.onMarshallerProcessorStarted((GridKernalContext)this, null);
        this.add((GridComponent)new IgnitePluginProcessor((GridKernalContext)this, this.config(), Collections.emptyList()));
        this.add((GridComponent)new GridInternalSubscriptionProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new GridSystemViewManager((GridKernalContext)this), false);
        this.add((GridComponent)new GridPortProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new GridClusterStateProcessor((GridKernalContext)this), true);
        this.add((GridComponent)new GridMetricManager((GridKernalContext)this), false);
        this.add((GridComponent)new GridTimeoutProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new IgniteAuthenticationProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new GridDeploymentManager((GridKernalContext)this), false);
        this.add((GridComponent)new MvccProcessorImpl((GridKernalContext)this), false);
        this.add((GridComponent)new GridContinuousProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new PlatformNoopProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new MigrationCacheProcessor((GridKernalContext)this));
        this.add((GridComponent)new GridQueryProcessor((GridKernalContext)this), true);
        this.add((GridComponent)new GridEventStorageManager((GridKernalContext)this), false);
        this.add((GridComponent)new NoOpIgniteSecurityProcessor((GridKernalContext)this, null), false);
        this.add((GridComponent)new PoolProcessor((GridKernalContext)this), true);
        this.add((GridComponent)new GridIoManager((GridKernalContext)this), false);
        this.add((GridComponent)new MaintenanceProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new GridEncryptionManager((GridKernalContext)this), false);
        this.add(new MigrationNodeFolderResolver(nodeFolder, nodeConsistentId));
        this.add((GridComponent)new GridDiscoveryManager((GridKernalContext)this), false);
        this.add((GridComponent)new GridResourceProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new GridAffinityProcessor((GridKernalContext)this), false);
        this.add((GridComponent)new CompressionProcessor((GridKernalContext)this));
        this.add((GridComponent)new GridIndexingManager((GridKernalContext)this), false);
        this.add((GridComponent)new CacheObjectBinaryProcessorImpl((GridKernalContext)this));
    }

    private static IgniteConfiguration adaptConfiguration(IgniteConfiguration cfg, File nodeFolder, Serializable nodeConsistentId, BinaryMarshaller marshaller) {
        CacheConfiguration[] cacheCfgs;
        IgniteConfiguration ret = new IgniteConfiguration(cfg);
        File workDir = nodeFolder.getParentFile().getParentFile();
        ret.setWorkDirectory(workDir.getAbsolutePath());
        ret.setConsistentId(nodeConsistentId);
        ret.setNodeId(UUID.randomUUID());
        ret.setIgniteInstanceName(null);
        ret.setAuthenticationEnabled(false);
        ret.setClientMode(false);
        ret.setPeerClassLoadingEnabled(false);
        if (ret.getDataStorageConfiguration().getCheckpointReadLockTimeout() == null) {
            ret.getDataStorageConfiguration().setCheckpointReadLockTimeout(10000L);
        }
        if ((cacheCfgs = ret.getCacheConfiguration()) == null) {
            ret.setCacheConfiguration(new CacheConfiguration[0]);
        } else {
            for (int i = 0; i < cacheCfgs.length; ++i) {
                if (cacheCfgs[i] != null) continue;
                cacheCfgs[i] = new CacheConfiguration();
            }
        }
        ret.setGridLogger((IgniteLogger)new LoggerBridge());
        ret.setDiscoverySpi((DiscoverySpi)new StandaloneNoopDiscoverySpi(){

            public Collection<ClusterNode> getRemoteNodes() {
                return Collections.emptyList();
            }
        });
        ret.setCommunicationSpi((CommunicationSpi)new StandaloneNoopCommunicationSpi());
        ret.setEventStorageSpi((EventStorageSpi)new NoopEventStorageSpi());
        ret.setMetricExporterSpi(new MetricExporterSpi[]{new NoopMetricExporterSpi()});
        ret.setSystemViewExporterSpi(new SystemViewExporterSpi[0]);
        ret.setDeploymentSpi((DeploymentSpi)new LocalDeploymentSpi());
        ret.setIndexingSpi((IndexingSpi)new NoopIndexingSpi());
        if (ret.getEncryptionSpi() == null) {
            ret.setEncryptionSpi((EncryptionSpi)new NoopEncryptionSpi());
        }
        ret.setCacheStoreSessionListenerFactories(null);
        ret.setMarshaller((Marshaller)marshaller);
        return ret;
    }

    public static List<String> validateConfigurations(IgniteConfiguration cfg) {
        ArrayList<String> errors = new ArrayList<String>(1);
        if (cfg.getDataStorageConfiguration() == null) {
            errors.add("DataStorageConfiguration must not be null");
        }
        return errors.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(errors);
    }

    public void start() throws IgniteCheckedException {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        for (GridComponent component : this.components()) {
            component.start();
        }
    }

    public void stop() throws IgniteCheckedException {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        List componentList = this.components();
        ListIterator it = componentList.listIterator(componentList.size());
        while (it.hasPrevious()) {
            GridComponent component = (GridComponent)it.previous();
            component.stop(true);
        }
    }

    static {
        try {
            CFG_FIELD = GridKernalContextImpl.class.getDeclaredField("cfg");
            CFG_FIELD.setAccessible(true);
            GRID_FIELD = GridKernalContextImpl.class.getDeclaredField("grid");
            GRID_FIELD.setAccessible(true);
            MARSH_CTX_FIELD = GridKernalContextImpl.class.getDeclaredField("marshCtx");
            MARSH_CTX_FIELD.setAccessible(true);
            JDK_MARSHALLER_FIELD = MarshallerContextImpl.class.getDeclaredField("jdkMarsh");
            JDK_MARSHALLER_FIELD.setAccessible(true);
            IO_STATS_MANAGER = GridKernalContextImpl.class.getDeclaredField("ioStatMgr");
            IO_STATS_MANAGER.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

