/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.mappers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.migrationtools.persistence.mappers.AbstractSchemaColumnsProcessor;
import org.apache.ignite.migrationtools.persistence.mappers.RecordAndTableSchemaMismatchException;
import org.apache.ignite.migrationtools.persistence.mappers.SchemaColumnProcessorStats;
import org.apache.ignite.migrationtools.types.converters.TypeConverterFactory;
import org.apache.ignite3.internal.client.table.ClientSchema;
import org.apache.ignite3.table.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreMismatchesSchemaColumnProcessor
extends AbstractSchemaColumnsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IgnoreMismatchesSchemaColumnProcessor.class);
    private Map<String, Long> droppedColumns = new HashMap<String, Long>();

    public IgnoreMismatchesSchemaColumnProcessor(ClientSchema schema, Map<String, String> fieldNameForColumn, TypeConverterFactory nativeTypeConverters) {
        super(schema, fieldNameForColumn, nativeTypeConverters, false);
    }

    @Override
    protected Tuple postProcessMappedTuple(Tuple mappedTuple, Collection<String> missingCols, Collection<String> additionalColumns) throws RecordAndTableSchemaMismatchException {
        if (!missingCols.isEmpty()) {
            throw new RecordAndTableSchemaMismatchException(missingCols, additionalColumns);
        }
        if (!additionalColumns.isEmpty()) {
            LOGGER.warn("Found additional columns in tuple: {} Ignoring..", additionalColumns);
            for (String colName : additionalColumns) {
                this.droppedColumns.compute(colName, (k, prev) -> (prev != null ? prev : 0L) + 1L);
            }
        }
        return mappedTuple;
    }

    @Override
    public SchemaColumnProcessorStats getStats() {
        SchemaColumnProcessorStats superStats = super.getStats();
        return new IgnoredColumnsStats(superStats.getProcessedElements(), this.droppedColumns);
    }

    public static class IgnoredColumnsStats
    extends SchemaColumnProcessorStats {
        private Map<String, Long> droppedColumns;

        private IgnoredColumnsStats() {
        }

        public IgnoredColumnsStats(long processedElements, Map<String, Long> droppedColumns) {
            super(processedElements);
            this.droppedColumns = Collections.unmodifiableMap(droppedColumns);
        }

        public Map<String, Long> getDroppedColumns() {
            return this.droppedColumns;
        }

        @Override
        public String toString() {
            return "Stats{processedElements=" + this.getProcessedElements() + ", droppedColumns=" + String.valueOf(this.droppedColumns) + "}";
        }
    }
}

