/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteUuid;

public class MigrationCacheProcessor
extends GridCacheProcessor {
    private static final Method READ_CACHE_DATA_METHOD;
    private static final Constructor<CacheGroupDescriptor> CACHE_GROUP_DESCRIPTOR_CONSTRUCTOR;
    private static final Method START_CACHE_IN_RECOVERY_METHOD;
    private static final Field RECOVERY_LISTENER_FIELD;
    private static final Method RESTORE_PARTITION_STATE_METHOD;
    private final Object recoveryField;
    private final Map<String, DynamicCacheDescriptor> cacheDescriptors = new HashMap<String, DynamicCacheDescriptor>();
    private FilePageStoreManager pageStoreManager;

    public MigrationCacheProcessor(GridKernalContext ctx) {
        super(ctx);
        try {
            this.recoveryField = RECOVERY_LISTENER_FIELD.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void start() throws IgniteCheckedException {
        super.start();
        this.pageStoreManager = (FilePageStoreManager)this.context().pageStore();
    }

    private DynamicCacheDescriptor computeDescriptor(String name) {
        StoredCacheData cacheData = this.readStoredCacheData(name);
        return this.computeDescriptor(cacheData);
    }

    private DynamicCacheDescriptor computeDescriptor(StoredCacheData cacheData) {
        String name = cacheData.config().getName();
        CacheType cacheType = CacheType.cacheType((String)name);
        CacheJoinNodeDiscoveryData.CacheInfo cacheJoinInfo = new CacheJoinNodeDiscoveryData.CacheInfo(cacheData, cacheType, cacheData.sql(), 1L, false);
        CacheJoinNodeDiscoveryData discoData = new CacheJoinNodeDiscoveryData(IgniteUuid.randomUuid(), Collections.singletonMap(name, cacheJoinInfo), Collections.emptyMap(), false);
        return this.registerNewCache(discoData, this.ctx.localNodeId(), cacheJoinInfo);
    }

    public DynamicCacheDescriptor cacheDescriptor(String name) {
        return this.cacheDescriptors.computeIfAbsent(name, this::computeDescriptor);
    }

    public Map<String, DynamicCacheDescriptor> cacheDescriptors() {
        return this.cacheDescriptors;
    }

    public Collection<DynamicCacheDescriptor> persistentCaches() {
        return Collections.unmodifiableCollection(this.cacheDescriptors.values());
    }

    public void loadAllDescriptors() throws IgniteCheckedException {
        Map cacheData = this.pageStoreManager.readCacheConfigurations();
        for (Map.Entry entry : cacheData.entrySet()) {
            this.cacheDescriptors.computeIfAbsent((String)entry.getKey(), key -> this.computeDescriptor((StoredCacheData)entry.getValue()));
        }
    }

    public void startCache(DynamicCacheDescriptor cacheDescr) {
        try {
            GridCacheContext cacheCtx = (GridCacheContext)START_CACHE_IN_RECOVERY_METHOD.invoke((Object)this, cacheDescr);
            RESTORE_PARTITION_STATE_METHOD.invoke(this.recoveryField, Collections.singleton(cacheCtx.group()), Collections.emptyMap());
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not start cache: " + String.valueOf(cacheDescr), ex);
        }
    }

    private DynamicCacheDescriptor registerNewCache(CacheJoinNodeDiscoveryData joinData, UUID nodeId, CacheJoinNodeDiscoveryData.CacheInfo cacheInfo) {
        CacheGroupDescriptor grpDesc;
        CacheConfiguration cfg = cacheInfo.cacheData().config();
        int cacheId = CU.cacheId((String)cfg.getName());
        int grpId = CU.cacheGroupId((String)cfg.getName(), (String)cfg.getGroupName());
        Map<String, Integer> caches = Collections.singletonMap(cfg.getName(), cacheId);
        boolean persistent = true;
        boolean walGloballyEnabled = this.ctx.clientNode() ? persistent : this.ctx.cache().context().database().walEnabled(grpId, false);
        try {
            grpDesc = CACHE_GROUP_DESCRIPTOR_CONSTRUCTOR.newInstance(cfg, cfg.getGroupName(), grpId, nodeId, null, joinData.cacheDeploymentId(), caches, persistent, walGloballyEnabled, null, cacheInfo.cacheData().cacheConfigurationEnrichment());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new DynamicCacheDescriptor(this.ctx, cfg, cacheInfo.cacheType(), grpDesc, false, nodeId, cacheInfo.isStaticallyConfigured(), cacheInfo.sql(), joinData.cacheDeploymentId(), new QuerySchema(cacheInfo.cacheData().queryEntities()), cacheInfo.cacheData().cacheConfigurationEnrichment());
    }

    private StoredCacheData readStoredCacheData(String cacheName) {
        File storeWorkDir = this.pageStoreManager.workDir();
        Path workDirPath = storeWorkDir.toPath();
        String folderName = "cache-" + cacheName;
        Path directCfgPath = workDirPath.resolve(folderName).resolve("cache_data.dat");
        Stream<Path> grpCandidates = null;
        try {
            String groupFileName = cacheName + "cache_data.dat";
            grpCandidates = Files.list(workDirPath).filter(path -> path.getFileName().toString().startsWith("cacheGroup-")).map(path -> path.resolve(groupFileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Stream.concat(Stream.of(directCfgPath), grpCandidates).filter(path -> Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])).map(Path::toFile).map(this::readCacheData).findFirst().orElseThrow();
    }

    private StoredCacheData readCacheData(File conf) {
        try {
            return (StoredCacheData)READ_CACHE_DATA_METHOD.invoke((Object)this.pageStoreManager, conf);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            READ_CACHE_DATA_METHOD = FilePageStoreManager.class.getDeclaredMethod("readCacheData", File.class);
            READ_CACHE_DATA_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            CACHE_GROUP_DESCRIPTOR_CONSTRUCTOR = CacheGroupDescriptor.class.getDeclaredConstructor(CacheConfiguration.class, String.class, Integer.TYPE, UUID.class, AffinityTopologyVersion.class, IgniteUuid.class, Map.class, Boolean.TYPE, Boolean.TYPE, Collection.class, CacheConfigurationEnrichment.class);
            CACHE_GROUP_DESCRIPTOR_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            START_CACHE_IN_RECOVERY_METHOD = GridCacheProcessor.class.getDeclaredMethod("startCacheInRecoveryMode", DynamicCacheDescriptor.class);
            START_CACHE_IN_RECOVERY_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            RECOVERY_LISTENER_FIELD = GridCacheProcessor.class.getDeclaredField("recovery");
            RECOVERY_LISTENER_FIELD.setAccessible(true);
            RESTORE_PARTITION_STATE_METHOD = RECOVERY_LISTENER_FIELD.getType().getDeclaredMethod("restorePartitionStates", Collection.class, Map.class);
            RESTORE_PARTITION_STATE_METHOD.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

