/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TraceableException;
import org.apache.ignite.lang.util.TraceIdUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteException
extends RuntimeException
implements TraceableException {
    private static final long serialVersionUID = 0L;
    private final String errorPrefix;
    private final String groupName;
    private final int code;
    private UUID traceId;

    public IgniteException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteException(UUID traceId, int code) {
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteException(int code, String message, boolean writableStackTrace) {
        this(UUID.randomUUID(), code, message, null, true, writableStackTrace);
    }

    public IgniteException(UUID traceId, int code, String message) {
        this(traceId, code, message, null);
    }

    public IgniteException(int code, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId((Throwable)cause), code, cause);
    }

    public IgniteException(UUID traceId, int code, @Nullable Throwable cause) {
        super(cause != null ? cause.getLocalizedMessage() : null, cause);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public IgniteException(int code, String message, @Nullable Throwable cause) {
        this(TraceIdUtils.getOrCreateTraceId((Throwable)cause), code, message, cause);
    }

    public IgniteException(UUID traceId, int code, String message, @Nullable Throwable cause) {
        this(traceId, code, message, cause, true, true);
    }

    public IgniteException(UUID traceId, int code, String message, @Nullable Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.traceId = traceId;
        ErrorGroup errorGroup = ErrorGroups.errorGroupByCode(code);
        this.groupName = errorGroup.name();
        this.errorPrefix = errorGroup.errorPrefix();
        this.code = code;
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return this.errorPrefix + "-" + this.groupName() + "-" + Short.toUnsignedInt(this.errorCode());
    }

    public short groupCode() {
        return ErrorGroups.extractGroupCode(this.code);
    }

    public short errorCode() {
        return ErrorGroup.extractErrorCode(this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + ErrorGroup.errorMessage(this.errorPrefix, this.traceId, this.groupName, this.code, this.getLocalizedMessage());
    }
}

