/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.lang.ErrorGroup;
import org.jetbrains.annotations.Nullable;

public class ErrorGroups {
    public static final String IGNITE_ERR_PREFIX = "IGN";
    private static final String PLACEHOLDER = "${ERROR_PREFIX}";
    private static final String EXCEPTION_MESSAGE_STRING_PATTERN = "(.*)(${ERROR_PREFIX})-([A-Z]+)-(\\d+)(\\s?)(.*)( TraceId:)([a-f0-9]{8})";
    private static Pattern EXCEPTION_MESSAGE_PATTERN;
    private static final HashSet<String> REGISTERED_ERROR_PREFIXES;
    private static final Map<Short, ErrorGroup> registeredGroups;

    public static synchronized void initialize() {
        for (Class<?> cls : ErrorGroups.class.getDeclaredClasses()) {
            try {
                cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize error groups", e);
            }
        }
    }

    public static synchronized ErrorGroup registerGroup(String groupName, short groupCode) {
        return ErrorGroups.registerGroup(IGNITE_ERR_PREFIX, groupName, groupCode);
    }

    public static synchronized ErrorGroup registerGroup(String errorPrefix, String groupName, short groupCode) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Group name is null or empty");
        }
        String grpName = groupName.toUpperCase(Locale.ENGLISH);
        if (registeredGroups.containsKey(groupCode)) {
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + registeredGroups.get(groupCode) + "]");
        }
        for (ErrorGroup group : registeredGroups.values()) {
            if (!group.name().equals(groupName)) continue;
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + group + "]");
        }
        if (REGISTERED_ERROR_PREFIXES.add(errorPrefix)) {
            String errorPrefixes = String.join((CharSequence)"|", REGISTERED_ERROR_PREFIXES);
            String pattern = EXCEPTION_MESSAGE_STRING_PATTERN.replace(PLACEHOLDER, errorPrefixes);
            EXCEPTION_MESSAGE_PATTERN = Pattern.compile(pattern, 32);
        }
        ErrorGroup newGroup = new ErrorGroup(errorPrefix, grpName, groupCode);
        registeredGroups.put(groupCode, newGroup);
        return newGroup;
    }

    @Nullable
    public static String extractCauseMessage(String errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        Matcher m = EXCEPTION_MESSAGE_PATTERN.matcher(errorMessage);
        return m.matches() ? m.group(6) : errorMessage;
    }

    public static short extractGroupCode(int code) {
        return (short)(code >>> 16);
    }

    public static ErrorGroup errorGroupByGroupCode(short groupCode) {
        return registeredGroups.get(groupCode);
    }

    public static ErrorGroup errorGroupByCode(int code) {
        ErrorGroup grp = registeredGroups.get(ErrorGroups.extractGroupCode(code));
        assert (grp != null) : "group not found, code=" + code;
        return grp;
    }

    static {
        REGISTERED_ERROR_PREFIXES = new HashSet();
        registeredGroups = new HashMap<Short, ErrorGroup>();
    }
}

