/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.ml.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ModelConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int batchSize;
    private final Map<String, Object> engineOptions;

    private ModelConfig(Builder builder) {
        this.batchSize = builder.batchSize;
        this.engineOptions = builder.engineOptions;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public Map<String, Object> engineOptions() {
        return this.engineOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int batchSize = 1;
        private Map<String, Object> engineOptions = new HashMap<String, Object>();

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder from(ModelConfig config) {
            this.batchSize = config.batchSize;
            this.engineOptions = new HashMap<String, Object>(config.engineOptions);
            return this;
        }

        public ModelConfig build() {
            return new ModelConfig(this);
        }
    }
}

