/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.table;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SubmissionPublisher;
import org.apache.calcite.util.Static;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyLocationTable;
import org.apache.ignite3.internal.table.TableImpl;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.SqlException;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.TupleHelper;
import org.gridgain.internal.sql.copy.Writer;
import org.jetbrains.annotations.Nullable;

public class TableWriter
implements Writer {
    private final SubmissionPublisher<DataStreamerItem<Tuple>> publisher;
    private final List<String> columnNames;
    private final List<Column> columns;
    private final SchemaDescriptor schemaDescriptor;
    private final CompletableFuture<Void> streamFut;
    private final String tableName;
    private int rowsCount = 0;

    public TableWriter(TableManager mgr, CopyLocationTable location, List<Column> columns, int batchSize, ExecutorService executor) {
        this.tableName = location.tableName();
        Table table = mgr.table("\"" + this.tableName + "\"");
        if (table == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, Static.RESOURCE.tableNotFound(this.tableName).str());
        }
        this.columnNames = location.columns();
        this.columns = columns;
        this.schemaDescriptor = ((TableImpl)table).schemaView().lastKnownSchema();
        this.columnNames.forEach(colName -> this.validateColumnName((String)colName, this.tableName));
        columns.forEach(col -> this.validateColumnName(col.name(), this.tableName));
        this.publisher = new SubmissionPublisher(executor, batchSize);
        DataStreamerOptions options = DataStreamerOptions.builder().pageSize(batchSize).autoFlushInterval(0).build();
        this.streamFut = table.recordView().streamData(this.publisher, options);
    }

    @Override
    public void write(List<?> item) throws IOException {
        DataStreamerItem<Tuple> dataStreamerItem = DataStreamerItem.of(this.asTuple(item));
        this.publisher.submit(dataStreamerItem);
        ++this.rowsCount;
    }

    @Override
    public void close() throws Exception {
        this.publisher.close();
        this.streamFut.join();
    }

    private Tuple asTuple(List<?> record) {
        if (this.columnNames.size() != record.size()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "the table has " + this.columnNames.size() + " columns but the row has " + record.size());
        }
        Tuple tuple = Tuple.create(this.columnNames.size());
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String columnName = this.columns.isEmpty() ? this.columnNames.get(i) : this.columns.get(i).name();
            Object value = record.get(i);
            TupleHelper.setNormalized(tuple, columnName, this.convert(value, columnName));
        }
        return tuple;
    }

    @Nullable
    private Object convert(Object val, String columnName) {
        if (val == null) {
            return null;
        }
        Column column = this.schemaDescriptor.column(columnName);
        ColumnType specExpected = column.type().spec();
        try {
            boolean isSameSpec;
            NativeType nativeType = NativeTypes.fromObject(val);
            if (nativeType == null) {
                return null;
            }
            ColumnType specActual = nativeType.spec();
            boolean bl = isSameSpec = specExpected == specActual;
            if (!isSameSpec && specActual == ColumnType.STRING) {
                return TableWriter.parseString((String)val, specExpected);
            }
            if (!isSameSpec && specActual == ColumnType.INT32) {
                return TableWriter.convertInteger((Integer)val, specExpected, columnName);
            }
            return val;
        }
        catch (Exception e) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Value conversion failed [table=" + this.tableName + ", rowNumber=" + this.rowsCount + ", column=" + columnName + ", from=" + val.getClass().getName() + ", to=" + specExpected.name() + ", value=" + val + "]", (Throwable)e);
        }
    }

    private static Object parseString(String s, ColumnType specExpected) {
        switch (specExpected) {
            case INT8: {
                return Byte.valueOf(s);
            }
            case INT16: {
                return Short.valueOf(s);
            }
            case INT32: {
                return Integer.valueOf(s);
            }
            case INT64: {
                return Long.valueOf(s);
            }
            case BOOLEAN: {
                return Boolean.valueOf(s);
            }
            case FLOAT: {
                return Float.valueOf(s);
            }
            case DOUBLE: {
                return Double.valueOf(s);
            }
            case DECIMAL: {
                return new BigDecimal(s);
            }
            case DATE: {
                return LocalDate.parse(s);
            }
            case TIME: {
                return LocalTime.parse(s);
            }
            case DATETIME: {
                return LocalDateTime.parse(s);
            }
            case TIMESTAMP: {
                return Instant.parse(s);
            }
            case UUID: {
                return UUID.fromString(s);
            }
            case BYTE_ARRAY: {
                return s.getBytes(StandardCharsets.UTF_8);
            }
        }
        return s;
    }

    private static Object convertInteger(Integer val, ColumnType specExpected, String columnName) {
        if (specExpected == ColumnType.INT8 && val >= -128 && val <= 127) {
            return val.byteValue();
        }
        if (specExpected == ColumnType.INT16 && val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
            return val.shortValue();
        }
        if (specExpected == ColumnType.INT64) {
            return val.longValue();
        }
        throw new RuntimeException("Value conversion failed [column=" + columnName + ", from=" + val.getClass().getName() + ", to=" + specExpected.name() + ", value=" + val + "]");
    }

    private void validateColumnName(String colName, String tableName) {
        if (this.schemaDescriptor.column(colName) == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, Static.RESOURCE.columnNotFoundInTable(colName, tableName).str());
        }
    }
}

