/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.sql.copy.parquet.s3;

import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.gridgain.internal.sql.copy.parquet.s3.BaseS3File;
import org.gridgain.internal.sql.copy.s3.S3InputStream;
import org.gridgain.internal.sql.copy.s3.S3Uri;
import software.amazon.awssdk.services.s3.S3Client;

public class S3InputFile
extends BaseS3File
implements InputFile {
    private Long length;

    public static S3InputFile fromLocation(String location, S3Client client) {
        return new S3InputFile(client, new S3Uri(location), null);
    }

    S3InputFile(S3Client client, S3Uri uri, Long length) {
        super(client, uri);
        this.length = length;
    }

    public long getLength() {
        if (this.length == null) {
            this.length = this.getObjectMetadata().contentLength();
        }
        return this.length;
    }

    public SeekableInputStream newStream() {
        return new S3InputStream(this.client(), this.uri());
    }
}

