/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.structure;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropMapEntry;
import org.apache.ignite3.internal.catalog.storage.NewMapEntry;
import org.gridgain.internal.snapshots.catalog.CommandState;
import org.gridgain.internal.snapshots.meta.MapDescriptorView;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.structure.Structure;
import org.gridgain.internal.snapshots.structure.StructureHandler;
import org.jetbrains.annotations.Nullable;

public class MapStructureHandler
implements StructureHandler {
    @Override
    public Set<Structure> getStructures(Catalog catalog) {
        return catalog.maps().stream().map(map -> Structure.toStructure(map.schemaId(), map.name(), map.id(), catalog, map.tableId())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public Structure getStructure(Catalog catalog, CatalogSchemaDescriptor schema, String structureName) {
        CatalogMapDescriptor map = schema.map(structureName);
        return map != null ? Structure.toStructure(map.schemaId(), map.name(), map.id(), catalog, map.tableId()) : null;
    }

    @Override
    public boolean tryRestoreStructure(UpdateContext updateContext, CommandState commandState, StructureView view, int schemaId, int tableId, AtomicInteger nextGeneratedStructureId) {
        if (!(view instanceof MapDescriptorView)) {
            return false;
        }
        CatalogMapDescriptor descriptor = MapStructureHandler.createMapDescriptor((MapDescriptorView)view, nextGeneratedStructureId.getAndIncrement(), schemaId, tableId);
        commandState.applyCommand(new NewMapEntry(descriptor));
        if (!view.tableName().equals(descriptor.name())) {
            StructureHandler.renameSystemTable(commandState, view, descriptor.name());
        }
        return true;
    }

    @Override
    public boolean tryDropStructure(UpdateContext updateContext, CommandState commandState, StructureView view) {
        if (!(view instanceof MapDescriptorView)) {
            return false;
        }
        String schemaName = view.schemaName();
        CatalogMapDescriptor existingMap = updateContext.catalog().map(schemaName, view.name());
        if (existingMap != null) {
            commandState.applyCommand(new DropMapEntry(existingMap.id()));
        }
        return true;
    }

    @Override
    public Set<StructureView> createStructureDescriptors(Catalog catalog, Set<Integer> structureIds) {
        return structureIds.stream().map(catalog::map).filter(Objects::nonNull).map(map -> new MapDescriptorView(map.name(), catalog.schema(map.schemaId()).name(), catalog.table(map.tableId()).name())).collect(Collectors.toSet());
    }

    @Override
    public Set<Structure> dependenciesForTables(Catalog catalog, Collection<CatalogTableDescriptor> tables) {
        return Set.of();
    }

    private static CatalogMapDescriptor createMapDescriptor(MapDescriptorView mapView, int id, int schemaId, int tableId) {
        return new CatalogMapDescriptor(id, tableId, schemaId, mapView.name());
    }
}

