/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.gridgain.internal.snapshots.SnapshotMetaSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystemManager;
import org.gridgain.internal.snapshots.filesystem.SnapshotUri;
import org.gridgain.internal.snapshots.meta.DescriptorViewFactory;
import org.gridgain.internal.snapshots.meta.SnapshotEncryptionMeta;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSchemaView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;
import org.gridgain.internal.snapshots.signature.SnapshotSignature;
import org.gridgain.internal.snapshots.signature.SnapshotSignatureSerializer;
import org.gridgain.internal.snapshots.structure.StructureHandler;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetaWriter {
    private final CatalogManager catalogManager;
    private final SnapshotFileSystemManager fileSystemManager;
    private final SnapshotMetaSerializer snapshotMetaSerializer;
    private final SnapshotSignatureSerializer snapshotSignatureSerializer;
    private final Executor threadPool;
    private final int chunkSize;

    public SnapshotMetaWriter(CatalogManager catalogManager, SnapshotFileSystemManager fileSystemManager, SnapshotMetaSerializer snapshotMetaSerializer, SnapshotSignatureSerializer snapshotSignatureSerializer, Executor threadPool, int chunkSize) {
        this.catalogManager = catalogManager;
        this.fileSystemManager = fileSystemManager;
        this.snapshotMetaSerializer = snapshotMetaSerializer;
        this.snapshotSignatureSerializer = snapshotSignatureSerializer;
        this.threadPool = threadPool;
        this.chunkSize = chunkSize;
    }

    public CompletableFuture<Void> saveSnapshotMeta(CreateSnapshotGlobalState snapshotState, @Nullable SnapshotSignature signature) {
        long timestampLong = snapshotState.timestamp().longValue();
        UUID parentSnapshotId = snapshotState.parentSnapshotId();
        Set<String> nodeNames = snapshotState.nodeNames();
        SnapshotUri snapshotUri = snapshotState.snapshotUri();
        Catalog catalog = this.catalogManager.activeCatalog(timestampLong);
        DescriptorViewFactory descriptorFactory = new DescriptorViewFactory(catalog);
        SnapshotFileSystem parentFileSystem = parentSnapshotId != null ? this.fileSystemManager.snapshotFileSystem(parentSnapshotId, snapshotUri) : null;
        Collection<TableSnapshotMeta> tableSnapshotMetas = this.tableSnapshotMetas(parentFileSystem, timestampLong, snapshotState.tableIds(), descriptorFactory);
        HashSet<StructureView> structureViews = new HashSet<StructureView>(snapshotState.structureIds().size());
        for (StructureHandler handler : StructureHandler.getStructureHandlers()) {
            structureViews.addAll(handler.createStructureDescriptors(catalog, snapshotState.structureIds()));
        }
        String providerName = snapshotState.encryptionProviderName();
        SnapshotEncryptionMeta snapshotEncryptionMeta = providerName != null ? new SnapshotEncryptionMeta(providerName, this.snapshotSignatureSerializer.serializeSnapshotSignature(signature, providerName)) : null;
        SnapshotMeta meta = new SnapshotMeta(snapshotState.operationId(), timestampLong, nodeNames, tableSnapshotMetas, structureViews, descriptorFactory.zoneViews(), parentSnapshotId, this.chunkSize, snapshotEncryptionMeta);
        SnapshotFileSystem snapshotFileSystem = this.fileSystemManager.snapshotFileSystem(meta.snapshotId(), snapshotUri);
        return CompletableFuture.runAsync(() -> this.snapshotMetaSerializer.writeSnapshotMeta(meta, snapshotFileSystem), this.threadPool);
    }

    private Collection<TableSnapshotMeta> tableSnapshotMetas(@Nullable SnapshotFileSystem parentFileSystem, long timestampLong, Set<Integer> tableIds, DescriptorViewFactory descriptorFactory) {
        Map<Integer, Integer> parentSnapshotCatalogTableVersionByTableId;
        if (parentFileSystem != null) {
            SnapshotMeta parentSnapshotMeta = this.snapshotMetaSerializer.readSnapshotMeta(parentFileSystem);
            parentSnapshotCatalogTableVersionByTableId = parentSnapshotMeta.tableSnapshotMetas().stream().map(meta -> meta.schema().tableDescriptor()).collect(Collectors.toMap(TableDescriptorView::tableId, TableDescriptorView::catalogTableVersion));
        } else {
            parentSnapshotCatalogTableVersionByTableId = null;
        }
        Catalog catalog = this.catalogManager.activeCatalog(timestampLong);
        ArrayList<TableSnapshotMeta> tableSnapshotMetas = new ArrayList<TableSnapshotMeta>();
        for (Integer tableId : tableIds) {
            CatalogTableDescriptor tableDescriptor = catalog.table(tableId);
            assert (tableDescriptor != null) : String.format("Table not found: id=%d, catalogVersion=%d", tableId, catalog.version());
            Integer parentSnapshotCatalogTableVersion = parentFileSystem == null ? null : parentSnapshotCatalogTableVersionByTableId.get(tableId);
            TableSchemaView schemaView = descriptorFactory.createTableSchemaView(tableDescriptor, parentSnapshotCatalogTableVersion);
            tableSnapshotMetas.add(new TableSnapshotMeta(schemaView));
        }
        return tableSnapshotMetas;
    }
}

