/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.filesystem;

import java.net.URI;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.gridgain.internal.snapshots.buffer.BufferedChannel;
import org.gridgain.internal.snapshots.buffer.ByteBufferPool;
import org.gridgain.internal.snapshots.buffer.ByteBufferPoolProvider;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;
import org.gridgain.internal.snapshots.buffer.EncryptionByteBufferPool;
import org.gridgain.internal.snapshots.buffer.SnapshotEncryptor;
import org.gridgain.internal.snapshots.filesystem.EncryptedChannelFactory;
import org.gridgain.internal.snapshots.filesystem.SnapshotPath;

public class EncryptedSnapshotPath
implements SnapshotPath {
    private final SnapshotPath delegatePath;
    private final EncryptedChannelFactory factory;
    private final EncryptionByteBufferPool bufferPool;

    public EncryptedSnapshotPath(SnapshotPath delegatePath, SnapshotEncryptor encryptor, ByteBufferPoolProvider bufferPoolProvider) {
        this.delegatePath = delegatePath;
        this.factory = new EncryptedChannelFactory(encryptor);
        this.bufferPool = bufferPoolProvider.encryptionPool(encryptor.cipher());
    }

    @Override
    public CompletableFuture<ReadableByteChannel> readChannel() {
        return this.delegatePath.readChannel().thenCompose(readChannel -> EncryptedSnapshotPath.wrapChannel(readChannel, this.bufferPool.dataPool(), SnapshotEncryptor.ENCRYPTION_BYTE_ORDER, this.factory::readableChannel));
    }

    @Override
    public CompletableFuture<WritableByteChannel> writeChannel() {
        return ((CompletableFuture)this.delegatePath.writeChannel().thenCompose(channel -> EncryptedSnapshotPath.wrapChannel(channel, this.bufferPool.dataPool(), SnapshotEncryptor.ENCRYPTION_BYTE_ORDER, this.factory::writableChannel))).thenCompose(encryptedWritableByteChannel -> EncryptedSnapshotPath.wrapChannel(encryptedWritableByteChannel, this.bufferPool.encryptedBlocksPool(), ByteOrder.BIG_ENDIAN, BufferedChannel::new));
    }

    @Override
    public URI uri() {
        return this.delegatePath.uri();
    }

    private static <T> CompletableFuture<T> wrapChannel(T channel, ByteBufferPool pool, ByteOrder order, BiFunction<T, DisposableByteBuffer, T> channelWrapper) {
        return pool.allocate(order).thenApply(buffer -> channelWrapper.apply(channel, (DisposableByteBuffer)buffer));
    }
}

