/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotUtils;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.CreateSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.jetbrains.annotations.Nullable;

public class SnapshotsCache
implements Flow.Subscriber<Entry>,
WatchListener {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotsCache.class);
    private final AtomicReference<CacheFrame> frame = new AtomicReference<CacheFrame>(new CacheFrame(new HashMap<Integer, UUID>()));
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CompletableFuture<Void> initCompletedFuture = new CompletableFuture();
    private final SnapshotManagerContext context;

    SnapshotsCache(SnapshotManagerContext context) {
        this.context = context;
    }

    public CacheFrame get() {
        return this.frame.get();
    }

    public CompletableFuture<Void> init() {
        if (!this.initialized.compareAndSet(false, true)) {
            return this.initCompletedFuture;
        }
        this.context.metaStorageManager().registerPrefixWatch(MetaStorageKeys.createSnapshotGlobalStatePrefix(), this);
        this.context.metaStorageManager().prefix(MetaStorageKeys.createSnapshotGlobalStatePrefix()).subscribe(this);
        return this.initCompletedFuture;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(Entry entry) {
        if (SnapshotUtils.isMissing(entry)) {
            return;
        }
        CreateSnapshotGlobalState state = CreateSnapshotGlobalStateSerializer.deserialize(entry.value());
        switch (state.status()) {
            case STARTED: 
            case FAILED: 
            case PREPARED: {
                break;
            }
            case COMPLETED: {
                this.updateCache(state);
                break;
            }
            default: {
                LOG.error("Unexpected snapshot status: {}", new Object[]{state.status()});
            }
        }
    }

    private void updateCache(CreateSnapshotGlobalState state) {
        HashMap<Integer, UUID> newTableIdToLatestSnapshotId;
        CacheFrame newFrame;
        CacheFrame currentFrame;
        if (state.tableIds().isEmpty() && state.structureIds().isEmpty()) {
            return;
        }
        do {
            currentFrame = this.frame.get();
            newTableIdToLatestSnapshotId = new HashMap<Integer, UUID>(currentFrame.tableId2latestSnapshotId);
            for (int tableId : state.tableIds()) {
                newTableIdToLatestSnapshotId.put(tableId, state.snapshotId());
            }
            for (int structureId : state.structureIds()) {
                newTableIdToLatestSnapshotId.put(structureId, state.snapshotId());
            }
        } while (!this.frame.compareAndSet(currentFrame, newFrame = new CacheFrame(newTableIdToLatestSnapshotId)));
        LOG.debug("Snapshots cache has been updated: {}, with state {}", newFrame, state);
    }

    @Override
    public CompletableFuture<Void> onUpdate(WatchEvent event) {
        for (EntryEvent entryEvent : event.entryEvents()) {
            this.onNext(entryEvent.newEntry());
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void onError(Throwable throwable) {
        this.initCompletedFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.initCompletedFuture.complete(null);
    }

    public static class CacheFrame {
        private final Map<Integer, UUID> tableId2latestSnapshotId;

        private CacheFrame(Map<Integer, UUID> tableId2latestSnapshotId) {
            this.tableId2latestSnapshotId = tableId2latestSnapshotId;
        }

        @Nullable
        public UUID getLatestSnapshotId(int tableId) {
            return this.tableId2latestSnapshotId.get(tableId);
        }

        public String toString() {
            return S.toString(CacheFrame.class, this);
        }
    }
}

