/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.gridgain.internal.snapshots.coordinator.LocalSnapshotStateListener;
import org.gridgain.internal.snapshots.coordinator.SnapshotRebalanceWatch;

class SnapshotCoordinatorState {
    private final long term;
    private final ConcurrentMap<UUID, LocalSnapshotStateListener> ongoingSnapshots;
    private final SnapshotRebalanceWatch rebalanceWatch;

    SnapshotCoordinatorState(long term, ConcurrentMap<UUID, LocalSnapshotStateListener> ongoingSnapshots, SnapshotRebalanceWatch rebalanceWatch) {
        this.term = term;
        this.ongoingSnapshots = ongoingSnapshots;
        this.rebalanceWatch = rebalanceWatch;
    }

    long term() {
        return this.term;
    }

    void onSnapshotOperationStarted(UUID operationId, LocalSnapshotStateListener listener) {
        this.ongoingSnapshots.put(operationId, listener);
    }

    void onSnapshotOperationComplete(UUID operationId) {
        this.ongoingSnapshots.remove(operationId);
        this.rebalanceWatch.removeOperation(operationId);
    }

    boolean hasOngoingSnapshotOperation(UUID operationId) {
        return this.ongoingSnapshots.containsKey(operationId);
    }

    SnapshotRebalanceWatch rebalanceWatch() {
        return this.rebalanceWatch;
    }
}

