/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.coordinator;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.metastorage.dsl.Operation;
import org.apache.ignite3.internal.metastorage.dsl.Operations;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalState;
import org.gridgain.internal.snapshots.communication.metastorage.DeleteSnapshotGlobalStateSerializer;
import org.gridgain.internal.snapshots.communication.metastorage.MetaStorageKeys;
import org.gridgain.internal.snapshots.communication.metastorage.SnapshotStatus;
import org.gridgain.internal.snapshots.coordinator.LocalSnapshotStateListener;
import org.gridgain.internal.snapshots.coordinator.SnapshotCoordinatorState;

class DeleteSnapshotLocalStateWatch
extends LocalSnapshotStateListener {
    private final DeleteSnapshotGlobalState snapshotState;

    DeleteSnapshotLocalStateWatch(SnapshotManagerContext context, SnapshotCoordinatorState snapshotCoordinatorState, DeleteSnapshotGlobalState initialState) {
        super(context, snapshotCoordinatorState, initialState.operationId(), initialState.nodeNames());
        this.snapshotState = initialState;
    }

    @Override
    protected String nodeNameFromKey(byte[] key) {
        return MetaStorageKeys.nodeNameFromDeleteLocalStateKey(key);
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotCompleteImpl(UUID operationId, String nodeName) {
        return this.updateStateAndRemoveLocalStates(SnapshotStatus.COMPLETED, "");
    }

    @Override
    protected CompletableFuture<List<Operation>> onSnapshotFailedImpl(UUID operationId, String nodeName, String message) {
        return this.updateStateAndRemoveLocalStates(SnapshotStatus.FAILED, message);
    }

    private CompletableFuture<List<Operation>> updateStateAndRemoveLocalStates(SnapshotStatus newStatus, String message) {
        DeleteSnapshotGlobalState newGlobalState = new DeleteSnapshotGlobalState(this.snapshotState.operationId(), newStatus, this.snapshotState.nodeNames(), this.snapshotState.targetSnapshotId(), this.snapshotState.startTime(), message, this.snapshotState.parentSnapshotId(), this.snapshotState.snapshotUri());
        ArrayList<Operation> operations = new ArrayList<Operation>(this.snapshotState.nodeNames().size() + 1);
        operations.add(Operations.put(MetaStorageKeys.deleteSnapshotGlobalStateKey(this.snapshotState.operationId()), DeleteSnapshotGlobalStateSerializer.serialize(newGlobalState)));
        operations.add(Operations.remove(MetaStorageKeys.deleteSnapshotLockKey(this.snapshotState.targetSnapshotId())));
        for (String nn : this.snapshotState.nodeNames()) {
            operations.add(Operations.remove(MetaStorageKeys.deleteSnapshotLocalStateKey(this.snapshotState.operationId(), nn)));
        }
        return CompletableFuture.completedFuture(operations);
    }
}

