/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.gridgain.internal.snapshots.buffer.BufferAllocationRequest;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;

public class ByteBufferPool {
    private static final IgniteLogger LOG = Loggers.forClass(ByteBufferPool.class);
    private final int capacityLimit;
    private final int bufferSize;
    private final int maxSlices;
    private final ByteBuffer bufferPool;
    private final Queue<DisposableByteBuffer> availableSlices = new ArrayDeque<DisposableByteBuffer>();
    private final Queue<BufferAllocationRequest> bufferRequests = new ArrayDeque<BufferAllocationRequest>();

    public ByteBufferPool(int capacityLimit, int bufferSize) {
        this.capacityLimit = capacityLimit;
        this.bufferSize = bufferSize;
        int unused = capacityLimit % bufferSize;
        if (unused != 0) {
            LOG.warn("The byte buffer pool is not used perfectly. The pool size is {} and the buffer size is {}, so {} bytes are not used.", capacityLimit, bufferSize, unused);
        }
        this.bufferPool = ByteBuffer.allocateDirect(capacityLimit - unused);
        this.maxSlices = this.fillBufferSlices();
    }

    public synchronized int availableCapacity() {
        return this.capacityLimit - (this.maxSlices - this.availableSlices.size()) * this.bufferSize;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public synchronized CompletableFuture<DisposableByteBuffer> allocate(ByteOrder byteOrder) {
        DisposableByteBuffer buffer = this.availableSlices.poll();
        return buffer != null ? CompletableFuture.completedFuture(buffer) : this.addRequest(byteOrder);
    }

    private CompletableFuture<DisposableByteBuffer> addRequest(ByteOrder byteOrder) {
        CompletableFuture<DisposableByteBuffer> future = new CompletableFuture<DisposableByteBuffer>();
        this.bufferRequests.offer(new BufferAllocationRequest(byteOrder, future));
        return future;
    }

    private synchronized void disposeBuffer(ByteBuffer buffer) {
        BufferAllocationRequest request = this.bufferRequests.poll();
        if (request != null) {
            buffer.clear();
            request.complete(this.wrap(buffer));
        } else {
            this.availableSlices.offer(this.wrap(buffer));
        }
    }

    private DisposableByteBuffer wrap(ByteBuffer buffer) {
        return new DisposableByteBuffer(buffer, () -> this.disposeBuffer(buffer));
    }

    private int fillBufferSlices() {
        for (int pos = 0; pos <= this.capacityLimit - this.bufferSize; pos += this.bufferSize) {
            this.bufferPool.position(pos);
            this.bufferPool.limit(pos + this.bufferSize);
            this.availableSlices.offer(this.wrap(this.bufferPool.slice()));
        }
        return this.availableSlices.size();
    }
}

