/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.gridgain.internal.snapshots.buffer.DisposableByteBuffer;

public class BufferedChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final DisposableByteBuffer disposableBuffer;

    public BufferedChannel(WritableByteChannel channel, DisposableByteBuffer buffer) {
        this.disposableBuffer = buffer;
        this.delegate = channel;
    }

    private ByteBuffer buffer() {
        return this.disposableBuffer.buffer();
    }

    @Override
    public int write(ByteBuffer data) throws IOException {
        int result = 0;
        while (data.hasRemaining()) {
            ByteBuffer buffer = this.buffer();
            if (buffer.position() == 0 && data.remaining() > buffer.capacity()) {
                int directWrite = data.remaining() / buffer.capacity() * buffer.capacity();
                int written = this.delegate.write(data.slice().limit(directWrite));
                result += written;
                data.position(data.position() + written);
            }
            if (buffer.remaining() >= data.remaining()) {
                int remaining = data.remaining();
                buffer.put(data);
                if (buffer.hasRemaining()) {
                    result += remaining;
                    continue;
                }
                result += this.saveBuffer();
                continue;
            }
            int oldLimit = data.limit();
            data.limit(data.position() + buffer.remaining());
            buffer.put(data);
            result += this.saveBuffer();
            data.limit(oldLimit);
        }
        return result;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.delegate.isOpen()) {
                this.saveBuffer();
            }
        }
        finally {
            this.disposableBuffer.dispose();
            this.delegate.close();
        }
    }

    private int saveBuffer() throws IOException {
        ByteBuffer buffer = this.buffer();
        if (buffer.position() > 0) {
            buffer.flip();
            int result = 0;
            while (buffer.hasRemaining()) {
                result += this.delegate.write(buffer);
            }
            buffer.clear();
            return result;
        }
        return 0;
    }
}

