/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.DefaultValue;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite3.internal.replicator.PartitionGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.QualifiedNameHelper;
import org.gridgain.internal.snapshots.SnapshotException;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.StructureView;
import org.gridgain.internal.snapshots.meta.TableColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;
import org.gridgain.lang.GridgainErrorGroups;

public class SnapshotUtils {
    public static void retainTablesAndStructures(SnapshotMeta snapshotMeta, Set<QualifiedName> tableNames, Set<QualifiedName> structures) {
        if (tableNames.isEmpty() && structures.isEmpty()) {
            return;
        }
        HashSet<QualifiedName> allTables = new HashSet<QualifiedName>(tableNames);
        Collection<StructureView> views = snapshotMeta.structureDescriptors();
        if (views != null) {
            if (structures.isEmpty()) {
                views.clear();
            } else {
                views.removeIf(view -> SnapshotUtils.notSelected(structures, view));
                views.forEach(view -> allTables.add(QualifiedNameHelper.fromNormalized("SYSTEM", view.tableName())));
            }
        }
        snapshotMeta.tableSnapshotMetas().removeIf(table -> SnapshotUtils.notSelected((Set<QualifiedName>)allTables, table.schema().tableDescriptor()));
    }

    private static boolean notSelected(Set<QualifiedName> selectedObjects, StructureView structureView) {
        return SnapshotUtils.notSelected(selectedObjects, structureView.schemaName(), structureView.name());
    }

    private static boolean notSelected(Set<QualifiedName> selectedObjects, TableDescriptorView tableDescriptor) {
        return SnapshotUtils.notSelected(selectedObjects, tableDescriptor.schemaName(), tableDescriptor.name());
    }

    private static boolean notSelected(Set<QualifiedName> selectedObjects, String schemaName, String objectName) {
        return !selectedObjects.contains(QualifiedNameHelper.fromNormalized(schemaName, objectName));
    }

    public static Set<QualifiedName> sequencesUsedByTables(Collection<TableSnapshotMeta> tables) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (TableSnapshotMeta table : tables) {
            for (TableColumnDescriptorView column : table.schema().tableDescriptor().columns()) {
                DefaultValue.FunctionCall functionCall;
                DefaultValue defaultValue = column.defaultValue() == null ? null : column.defaultValue().toDefaultValue();
                if (!(defaultValue instanceof DefaultValue.FunctionCall) || !"NEXTVAL".equalsIgnoreCase((functionCall = (DefaultValue.FunctionCall)defaultValue).functionName())) continue;
                List<Object> parameters = functionCall.parameters();
                String fullSequenceName = (String)parameters.get(1);
                result.add(QualifiedName.parse(fullSequenceName));
            }
        }
        return result;
    }

    public static boolean isMissing(Entry entry) {
        return entry == null || entry.value() == null;
    }

    public static List<CatalogTableDescriptor> tempTableDescriptors(SnapshotMeta snapshotMeta, UUID operationId, Catalog catalog) {
        String tmpPrefix = SnapshotManager.tmpTableNamePrefix(operationId);
        return snapshotMeta.tableSnapshotMetas().stream().map(tableMeta -> tableMeta.schema().tableDescriptor()).map(tableDescriptor -> {
            String tmpName = tmpPrefix + tableDescriptor.name();
            return catalog.table(tableDescriptor.schemaName(), tmpName);
        }).collect(Collectors.toList());
    }

    public static CompletableFuture<Void> awaitPrimaryReplicas(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        return context.nodeProperties().colocationEnabled() ? SnapshotUtils.awaitPrimaryReplicasForZones(context, tableDescriptors, catalog) : SnapshotUtils.awaitPrimaryReplicasForTables(context, tableDescriptors, catalog);
    }

    private static CompletableFuture<Void> awaitPrimaryReplicasForTables(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        HybridTimestamp now = context.clock().now();
        CompletableFuture[] awaitFutures = (CompletableFuture[])tableDescriptors.stream().flatMap(tableDescriptor -> {
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(tableDescriptor.zoneId());
            assert (zoneDescriptor != null) : "Zone descriptor is null for zone ID: " + tableDescriptor.zoneId();
            int tableId = tableDescriptor.id();
            String tableName = tableDescriptor.name();
            return IntStream.range(0, zoneDescriptor.partitions()).mapToObj(partId -> new TablePartitionId(tableId, partId)).map(tablePartitionId -> SnapshotUtils.awaitPrimaryReplica(context, tablePartitionId, tableName, now, false));
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(awaitFutures);
    }

    private static CompletableFuture<Void> awaitPrimaryReplicasForZones(SnapshotManagerContext context, Collection<CatalogTableDescriptor> tableDescriptors, Catalog catalog) {
        HybridTimestamp now = context.clock().now();
        CompletableFuture[] awaitFutures = (CompletableFuture[])tableDescriptors.stream().map(CatalogTableDescriptor::zoneId).distinct().flatMap(zoneId -> {
            CatalogZoneDescriptor zoneDescriptor = catalog.zone((int)zoneId);
            assert (zoneDescriptor != null) : "Zone descriptor is null for zone ID: " + zoneId;
            String zoneName = zoneDescriptor.name();
            return IntStream.range(0, zoneDescriptor.partitions()).mapToObj(partId -> new ZonePartitionId((int)zoneId, partId)).map(zonePartitionId -> SnapshotUtils.awaitPrimaryReplica(context, zonePartitionId, zoneName, now, true));
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(awaitFutures);
    }

    private static CompletableFuture<?> awaitPrimaryReplica(SnapshotManagerContext context, PartitionGroupId partitionId, String objectName, HybridTimestamp timestamp, boolean colocationEnabled) {
        int timeout = context.properties().awaitPrimaryReplicaTimeoutSeconds();
        return context.placementDriver().awaitPrimaryReplica(partitionId, timestamp, timeout, TimeUnit.SECONDS).exceptionally(e -> {
            if ((e = ExceptionUtils.unwrapCause(e)) instanceof PrimaryReplicaAwaitTimeoutException) {
                if (colocationEnabled) {
                    int zoneId = partitionId.objectId();
                    throw new SnapshotException(GridgainErrorGroups.Snapshots.SNAPSHOT_REPLICA_TIMEOUT_ERR, String.format("Timed out while waiting for the primary replica to appear. Zone [zoneId=%d zoneName=%s] can be under rebalance or has empty data nodes or the cluster has lost majority for one of its partitions.", zoneId, objectName), (Throwable)e);
                }
                int tableId = partitionId.objectId();
                throw new SnapshotException(GridgainErrorGroups.Snapshots.SNAPSHOT_REPLICA_TIMEOUT_ERR, String.format("Timed out while waiting for the primary replica to appear. Table [tableId=%d tableName=%s] is under rebalance or belongs to a zone with empty data nodes or the cluster has lost majority for one of its partitions.", tableId, objectName), (Throwable)e);
            }
            throw new SnapshotException(String.format("Internal error while waiting for primary replica [partitionId=%s, objectName=%s].", partitionId, objectName), (Throwable)e);
        });
    }
}

