/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.snapshots;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.schema.BinaryRowUpgrader;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.SchemaUtils;
import org.apache.ignite3.internal.schema.registry.SchemaRegistryImpl;
import org.apache.ignite3.internal.table.TableImpl;
import org.apache.ignite3.internal.table.distributed.PartitionSet;
import org.gridgain.internal.recovery.PartitionsCalculator;
import org.gridgain.internal.recovery.RaftLogTruncater;
import org.gridgain.internal.recovery.RecoveryManager;
import org.gridgain.internal.recovery.RecoveryRequest;
import org.gridgain.internal.recovery.TableInfo;
import org.gridgain.internal.recovery.progress.LogProgressHandler;
import org.gridgain.internal.snapshots.SnapshotContext;
import org.gridgain.internal.snapshots.SnapshotManager;
import org.gridgain.internal.snapshots.SnapshotManagerContext;
import org.gridgain.internal.snapshots.SnapshotUtils;
import org.gridgain.internal.snapshots.TableSnapshotReader;
import org.gridgain.internal.snapshots.communication.metastorage.RestoreSnapshotGlobalState;
import org.gridgain.internal.snapshots.filesystem.SnapshotFileSystem;
import org.gridgain.internal.snapshots.meta.SnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableColumnDescriptorView;
import org.gridgain.internal.snapshots.meta.TableDescriptorView;
import org.gridgain.internal.snapshots.meta.TableSnapshotMeta;
import org.gridgain.internal.snapshots.meta.TableVersionView;

class SnapshotReader {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotReader.class);
    private final SnapshotManagerContext context;
    private final RecoveryManager recoveryManager;
    private final PartitionsCalculator partitionsCalculator;

    SnapshotReader(SnapshotManagerContext context) {
        this.context = context;
        this.partitionsCalculator = new PartitionsCalculator(context.nodeName(), context.metaStorageManager(), context.nodeProperties());
        RaftLogTruncater raftLogTruncater = new RaftLogTruncater(context.nodeName(), context.tableManager(), context.partitionReplicaLifecycleManager(), context.replicaManager(), context.nodeProperties(), context.busyLock());
        this.recoveryManager = new RecoveryManager(tableId -> (TableImpl)context.tableManager().cachedTable(tableId), raftLogTruncater::truncateRaftLog);
    }

    CompletableFuture<Long> restoreSnapshot(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext) {
        return snapshotContext.inBusyLockAsync(() -> {
            SnapshotMeta snapshotMeta;
            ArrayDeque<SnapshotMeta> snapshotMetasAsc = new ArrayDeque<SnapshotMeta>();
            RestoreSnapshotGlobalState snapshotState = (RestoreSnapshotGlobalState)snapshotContext.snapshotState();
            UUID snapshotId = snapshotState.targetSnapshotId();
            do {
                SnapshotFileSystem snapshotFileSystem = this.context.snapshotFileSystemManager().snapshotFileSystem(snapshotId, snapshotState.snapshotUri());
                snapshotMeta = this.context.snapshotMetaSerializer().readSnapshotMeta(snapshotFileSystem);
                snapshotMetasAsc.addFirst(snapshotMeta);
            } while ((snapshotId = snapshotMeta.parentSnapshotId()) != null);
            snapshotMetasAsc.forEach(meta -> SnapshotUtils.retainTablesAndStructures(meta, snapshotState.tableNames(), snapshotState.structureNames()));
            return this.restoreSnapshotImpl(snapshotContext, snapshotMetasAsc);
        });
    }

    private CompletableFuture<Long> restoreSnapshotImpl(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, Deque<SnapshotMeta> snapshotMetasAsc) {
        Map<Object, Object> descriptorViewsAscByTableId = snapshotMetasAsc.size() > 1 ? snapshotMetasAsc.stream().flatMap(it -> it.tableSnapshotMetas().stream()).map(it -> it.schema().tableDescriptor()).collect(Collectors.groupingBy(TableDescriptorView::tableId)) : Collections.emptyMap();
        Iterator<CompletableFuture<RecoveryRequest>> requests = snapshotMetasAsc.stream().map(meta -> this.createRecoveryRequest(snapshotContext, (SnapshotMeta)meta, (Map<Integer, List<TableDescriptorView>>)descriptorViewsAscByTableId, meta.snapshotId().equals(((RestoreSnapshotGlobalState)snapshotContext.snapshotState()).targetSnapshotId()))).iterator();
        return this.chain(snapshotContext, requests, 0L);
    }

    private CompletableFuture<Long> chain(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, Iterator<CompletableFuture<RecoveryRequest>> iterator, long rowsCount) {
        if (!iterator.hasNext()) {
            return CompletableFuture.completedFuture(rowsCount);
        }
        return ((CompletableFuture)snapshotContext.inBusyLockAsync(iterator::next).thenComposeAsync(request -> snapshotContext.inBusyLockAsync(() -> this.recoveryManager.process((RecoveryRequest)request)), (Executor)this.context.threadPool())).thenComposeAsync(prevRowsCount -> this.chain(snapshotContext, iterator, prevRowsCount + rowsCount), (Executor)this.context.threadPool());
    }

    private CompletableFuture<RecoveryRequest> createRecoveryRequest(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, SnapshotMeta snapshotMeta, Map<Integer, List<TableDescriptorView>> descriptorViewsAscByTableId, boolean lastInChain) {
        List<CatalogTableDescriptor> tableDescriptors = snapshotMeta.tableSnapshotMetas().stream().map(tableSnapshotMeta -> {
            TableDescriptorView tableDescriptorView = tableSnapshotMeta.schema().tableDescriptor();
            return this.tmpTableDescriptor(snapshotContext, tableDescriptorView);
        }).collect(Collectors.toList());
        return this.partitionsCalculator.calculatePartitions(tableDescriptors, snapshotContext.causalityToken()).thenApplyAsync(partitions -> RecoveryRequest.builder().id(snapshotContext.operationId()).tables(this.tableInfos(snapshotContext, snapshotMeta, descriptorViewsAscByTableId, (Map<Integer, PartitionSet>)partitions)).timestampToRecovery(this.context.clock().now()).threadPool(this.context.threadPool()).recoveryBatchSize((Integer)this.context.replicationConfiguration().batchSizeBytes().value()).handler(new LogProgressHandler(snapshotContext.operationId(), LOG)).lastInChain(lastInChain).build(), (Executor)this.context.threadPool());
    }

    private List<TableInfo> tableInfos(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, SnapshotMeta snapshotMeta, Map<Integer, List<TableDescriptorView>> descriptorViewsAscByTableId, Map<Integer, PartitionSet> partitions) {
        SnapshotFileSystem snapshotFileSystem = this.context.snapshotFileSystemManager().snapshotFileSystem(snapshotMeta.snapshotId(), snapshotContext.snapshotState().snapshotUri());
        Collection<TableSnapshotMeta> tableSnapshotMetas = snapshotMeta.tableSnapshotMetas();
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>(tableSnapshotMetas.size());
        for (TableSnapshotMeta tableSnapshotMeta : tableSnapshotMetas) {
            TableDescriptorView tableDescriptorView = tableSnapshotMeta.schema().tableDescriptor();
            int tableId = tableDescriptorView.tableId();
            List<TableDescriptorView> descriptorsHistory = descriptorViewsAscByTableId.get(tableId);
            int version = descriptorsHistory == null ? 1 : tableDescriptorView.catalogTableVersion() - descriptorsHistory.get(0).catalogTableVersion() + 1;
            TableSnapshotReader tableSnapshotReader = new TableSnapshotReader(tableSnapshotMeta, snapshotFileSystem, version, snapshotContext.operationId(), tableId, tableDescriptorView.name(), snapshotMeta.chunkSize());
            CatalogTableDescriptor tmpTableDescriptor = this.tmpTableDescriptor(snapshotContext, tableDescriptorView);
            BinaryRowUpgrader rowUpgrader = descriptorsHistory == null ? null : SnapshotReader.toRowUpgrader(descriptorsHistory);
            tableInfos.add(new TableInfo(tableSnapshotReader, rowUpgrader, partitions.get(this.context.nodeProperties().colocationEnabled() ? tmpTableDescriptor.zoneId() : tmpTableDescriptor.id()), tmpTableDescriptor.id(), tmpTableDescriptor.zoneId()));
        }
        return tableInfos;
    }

    private CatalogTableDescriptor tmpTableDescriptor(SnapshotContext<RestoreSnapshotGlobalState> snapshotContext, TableDescriptorView tableDescriptorView) {
        int catalogVersion = snapshotContext.snapshotState().catalogVersion();
        Catalog catalog = this.context.catalogManager().catalog(catalogVersion);
        String tempTableName = SnapshotManager.tmpTableNamePrefix(snapshotContext.operationId()) + tableDescriptorView.name();
        CatalogSchemaDescriptor schemaDescriptor = catalog.schema(tableDescriptorView.schemaName());
        assert (schemaDescriptor != null) : "Schema descriptor is not found for schema: " + tableDescriptorView.schemaName();
        CatalogTableDescriptor tableDescriptor = schemaDescriptor.table(tempTableName);
        assert (tableDescriptor != null) : "Table descriptor is not found for table: " + tempTableName;
        return tableDescriptor;
    }

    private static BinaryRowUpgrader toRowUpgrader(List<TableDescriptorView> tableDescriptorViewsAsc) {
        assert (!tableDescriptorViewsAsc.isEmpty());
        ArrayList<SchemaDescriptor> schemaDescriptors = new ArrayList<SchemaDescriptor>(tableDescriptorViewsAsc.size());
        int version = 1;
        SchemaDescriptor previousSchemaDescriptor = null;
        for (TableDescriptorView tableDescriptor : tableDescriptorViewsAsc) {
            for (TableVersionView tableVersion : tableDescriptor.tableSchemaVersions()) {
                List<Column> columns = tableVersion.columns().stream().map(TableColumnDescriptorView::toColumn).collect(Collectors.toList());
                SchemaDescriptor schemaDescriptor = new SchemaDescriptor(version, columns, List.of(), null);
                if (previousSchemaDescriptor != null) {
                    schemaDescriptor.columnMapping(SchemaUtils.columnMapper(previousSchemaDescriptor, schemaDescriptor));
                }
                schemaDescriptors.add(schemaDescriptor);
                previousSchemaDescriptor = schemaDescriptor;
                ++version;
            }
        }
        assert (previousSchemaDescriptor != null);
        SchemaRegistryImpl schemaRegistry = new SchemaRegistryImpl(ver -> (SchemaDescriptor)schemaDescriptors.get(ver - 1), previousSchemaDescriptor);
        return new BinaryRowUpgrader((SchemaRegistry)schemaRegistry, previousSchemaDescriptor);
    }
}

