/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.ldap.configuration.validator;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.gridgain.internal.security.ldap.configuration.validator.LdapUrlValidator;

public class LdapUrlValidatorImpl
implements Validator<LdapUrlValidator, String> {
    private static final IgniteLogger LOG = Loggers.forClass(LdapUrlValidatorImpl.class);
    public static final LdapUrlValidatorImpl INSTANCE = new LdapUrlValidatorImpl();
    private static final String LDAP_SCHEMA = "ldap";
    private static final String LDAP_SSL_SCHEMA = "ldaps";

    @Override
    public void validate(LdapUrlValidator annotation, ValidationContext<String> ctx) {
        String url = ctx.getNewValue();
        try {
            URI uri = new URI(url);
            String schema = uri.getScheme();
            if (!LDAP_SCHEMA.equals(schema) && !LDAP_SSL_SCHEMA.equals(schema)) {
                ctx.addIssue(new ValidationIssue(schema, "Unsupported schema type for LDAP URL. Supported schemas=[ldap, ldaps], provided schema=[" + schema + "]."));
            }
        }
        catch (URISyntaxException e) {
            LOG.debug("Failed to parse LDAP server url", (Throwable)e);
            ctx.addIssue(new ValidationIssue(url, "Failed to parse LDAP server url."));
        }
    }
}

