/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.security.jwt;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.security.jwt.configuration.JwtConfiguration;
import org.gridgain.internal.security.jwt.store.BlockListStore;

class BlockList {
    private static final long CLEANER_INTERVAL = 60L;
    private final BlockListStore store;

    BlockList(MetaStorageManager metaStorageManager, JwtConfiguration jwtConfiguration, String nodeName) {
        this.store = new BlockListStore(metaStorageManager, 60L, TimeUnit.MINUTES, jwtConfiguration, nodeName);
    }

    void start() {
        this.store.start();
    }

    void stop() {
        this.store.stop();
    }

    CompletableFuture<Void> revokeToken(String token, Instant expirationTime) {
        return this.store.saveToken(token, expirationTime);
    }

    CompletableFuture<Void> revokeTokensIssuedBefore(String username, Instant timestamp) {
        return this.store.saveUsernameAndTimestamp(username, timestamp);
    }

    boolean isTokenRevoked(String token, String username, Instant issuedAt) {
        if (this.store.isTokenBlocked(token)) {
            return true;
        }
        Instant timestamp = this.store.getTimestamp(username);
        return timestamp != null && issuedAt.isBefore(timestamp);
    }
}

