/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.jwt.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;
import org.gridgain.internal.security.jwt.exception.JwtValidationException;

@Singleton
@Requires(classes={JwtValidationException.class, ExceptionHandler.class})
public class JwtValidationExceptionHandler
implements ExceptionHandler<JwtValidationException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, JwtValidationException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).traceId(exception.traceId()).code(exception.codeAsString()).detail(exception.getMessage()));
    }
}

