/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest.jwt;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.token.validator.TokenValidator;
import java.util.Set;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.security.jwt.TokenManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JwtValidator
implements TokenValidator,
ResourceHolder {
    private static final IgniteLogger LOG = Loggers.forClass(JwtValidator.class);
    private static final String loginPath = "/management/v1/authentication/login";
    private TokenManager tokenManager;
    private LicenseFeatureChecker licenseFeatureChecker;

    public JwtValidator(TokenManager tokenManager, LicenseFeatureChecker licenseFeatureChecker) {
        this.tokenManager = tokenManager;
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    public Publisher<Authentication> validateToken(String token, HttpRequest<?> request) {
        try {
            this.licenseFeatureChecker.checkAnyFeature(Set.of(LicenseFeature.JWT_AUTH, LicenseFeature.SECURITY));
        }
        catch (MissingRequiredFeaturesException e) {
            LOG.info("JWT token validation failed due to the failed license feature check", (Throwable)e);
            return Mono.error((Throwable)e);
        }
        if (loginPath.equals(request.getPath())) {
            return Mono.empty();
        }
        try {
            UserDetails userDetails = this.tokenManager.validateAndExtractDetails(token);
            return Mono.just((Object)Authentication.build((String)userDetails.username(), userDetails.roles()));
        }
        catch (Exception e) {
            LOG.debug("Failed to validate token", (Throwable)e);
            return Mono.error((Throwable)AuthenticationResponse.exception((String)e.getMessage()));
        }
    }

    @Override
    public void cleanResources() {
        this.tokenManager = null;
        this.licenseFeatureChecker = null;
    }
}

