/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rest;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import java.util.Set;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public abstract class BaseLicenseCheckHttpServerFilter
implements HttpServerFilter,
ResourceHolder {
    private LicenseFeatureChecker licenseFeatureChecker;

    protected BaseLicenseCheckHttpServerFilter(LicenseFeatureChecker licenseFeatureChecker) {
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    protected abstract Set<LicenseFeature> features();

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        this.licenseFeatureChecker.checkAnyFeature(this.features());
        return Mono.from((Publisher)chain.proceed(request));
    }

    public int getOrder() {
        return 100;
    }

    @Override
    public void cleanResources() {
        this.licenseFeatureChecker = null;
    }
}

