/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.roles;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.rbac.assignments.RoleAssignmentManagement;
import org.gridgain.internal.rbac.assignments.exception.RoleAssignmentExistsException;
import org.gridgain.internal.rbac.assignments.exception.RoleGrantedException;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleManagement;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.roles.exception.RoleAlreadyExistsException;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.rbac.roles.exception.RoleValidationException;
import org.gridgain.internal.rbac.users.exception.SystemUserModificationException;

public class RoleManagementImpl
implements RoleManagement {
    private final RoleStore roleStore;
    private final RoleAssignmentManagement roleAssignmentManagement;
    private final Authorizer authorizer;

    public RoleManagementImpl(RoleStore roleStore, RoleAssignmentManagement roleAssignmentManagement, Authorizer authorizer) {
        this.roleStore = roleStore;
        this.roleAssignmentManagement = roleAssignmentManagement;
        this.authorizer = authorizer;
    }

    @Override
    public CompletableFuture<Void> createAsync(Role role) {
        return this.authorizer.authorizeThenCompose(Action.CREATE_ROLE, () -> {
            RoleManagementImpl.checkSystemRoleModification(role.name(), "System role can not be created.");
            return this.roleStore.putIfNotExists(role.name(), role).thenAccept(res -> {
                switch (res) {
                    case SUCCESS: {
                        return;
                    }
                    case ROLE_EXISTS: {
                        throw new RoleAlreadyExistsException(role.name());
                    }
                }
                throw new IllegalStateException("Unexpected operation result: " + res);
            });
        });
    }

    @Override
    public CompletableFuture<Void> dropAsync(String roleName, boolean withRevoke) {
        if (Objects.equals(roleName, "system")) {
            return CompletableFuture.failedFuture(new RoleValidationException("Cannot drop the super role system"));
        }
        Set<Privilege> requiredPrivileges = Set.of(Privilege.fromAction(Action.DROP_ROLE), Privilege.fromAction(Action.READ_ROLE));
        return this.authorizer.authorizeThenCompose(requiredPrivileges, () -> {
            RoleManagementImpl.checkSystemRoleModification(roleName, "System role can not be removed.");
            return ((CompletableFuture)this.roleAssignmentManagement.usernamesByRoleAsync(roleName).thenCompose(usernames -> {
                if (usernames.isEmpty()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                if (withRevoke) {
                    return this.roleAssignmentManagement.revokeAsync(Set.of(roleName), (Set<String>)usernames);
                }
                return CompletableFuture.failedFuture(new RoleAssignmentExistsException(roleName));
            })).thenCompose(ignore -> this.roleStore.removeIfExists(roleName).thenAccept(res -> {
                switch (res) {
                    case SUCCESS: {
                        return;
                    }
                    case ROLE_GRANTED: {
                        throw new RoleGrantedException(roleName);
                    }
                    case ROLE_NOT_FOUND: {
                        throw new RoleNotFoundException(roleName);
                    }
                }
                throw new IllegalStateException("Unexpected operation result: " + res);
            }));
        });
    }

    @Override
    public CompletableFuture<Role> findByNameAsync(String roleName) {
        return this.authorizer.authorizeAsync(Action.READ_ROLE).thenApply(unused -> {
            Role role = (Role)this.roleStore.get(roleName);
            if (role == null) {
                throw new RoleNotFoundException(roleName);
            }
            return role;
        });
    }

    @Override
    public CompletableFuture<Collection<Role>> findAllAsync() {
        return this.authorizer.authorizeAsync(Action.READ_ROLE).thenApply(unused -> this.roleStore.getAll());
    }

    private static void checkSystemRoleModification(String roleName, String message) {
        if (roleName.equalsIgnoreCase("gridgain-system-bypass")) {
            throw new SystemUserModificationException(message);
        }
    }
}

