/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.rbac.privileges;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.gridgain.internal.rbac.AssignmentOperationResult;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.PrivilegeAlias;
import org.gridgain.internal.rbac.privileges.PrivilegeGrants;
import org.gridgain.internal.rbac.privileges.PrivilegeManagement;
import org.gridgain.internal.rbac.roles.Role;
import org.gridgain.internal.rbac.roles.RoleStore;
import org.gridgain.internal.rbac.roles.exception.RoleNotFoundException;
import org.gridgain.internal.rbac.roles.exception.RoleValidationException;
import org.gridgain.internal.rbac.store.OperationResultContainer;

public class PrivilegeManagementImpl
implements PrivilegeManagement {
    private static final IgniteLogger LOG = Loggers.forClass(PrivilegeManagementImpl.class);
    private final PrivilegeGrants privilegeGrantsStore;
    private final RoleStore roleStore;
    private final Authorizer authorizer;

    public PrivilegeManagementImpl(PrivilegeGrants privilegeGrantsStore, RoleStore roleStore, Authorizer authorizer) {
        this.privilegeGrantsStore = privilegeGrantsStore;
        this.roleStore = roleStore;
        this.authorizer = authorizer;
    }

    @Override
    public CompletableFuture<Void> grantAsync(Set<Privilege> privileges, Set<String> roles) {
        String superRole = PrivilegeManagementImpl.superRole();
        if (superRole != null) {
            if (roles.stream().anyMatch(superRole::equalsIgnoreCase)) {
                return CompletableFuture.failedFuture(new RoleValidationException("Cannot grant privileges to the super role: " + superRole));
            }
        }
        return this.authorizer.authorizeThenCompose(Action.GRANT_PRIVILEGE, () -> this.privilegeGrantsStore.grant(privileges, roles).thenAccept(PrivilegeManagementImpl::processOperationResult));
    }

    @Override
    public CompletableFuture<Void> grantAsync(PrivilegeAlias privilegeAlias, Set<String> roles) {
        String superRole = PrivilegeManagementImpl.superRole();
        if (superRole != null) {
            if (roles.stream().anyMatch(superRole::equalsIgnoreCase)) {
                return CompletableFuture.failedFuture(new RoleValidationException("Cannot grant privileges to the super role: " + superRole));
            }
        }
        return this.authorizer.authorizeThenCompose(Action.GRANT_PRIVILEGE, () -> this.privilegeGrantsStore.grant(privilegeAlias.toPrivileges(), roles).thenAccept(PrivilegeManagementImpl::processOperationResult));
    }

    @Override
    public CompletableFuture<Set<Privilege>> getPrivilegesAsync(String roleName) {
        return this.authorizer.authorizeAsync(Action.READ_ROLE).thenApply(unused -> {
            Role role = (Role)this.roleStore.get(roleName);
            if (role == null) {
                throw new RoleNotFoundException(roleName);
            }
            return role.privileges();
        });
    }

    @Override
    public CompletableFuture<Map<String, Set<Privilege>>> getRolesWithPrivilegesAsync() {
        return this.authorizer.authorizeAsync(Action.READ_ROLE).thenApply(unused -> this.roleStore.getAll().stream().collect(Collectors.toMap(Role::name, Role::privileges)));
    }

    @Override
    public CompletableFuture<Void> revokeAsync(Set<Privilege> privileges, Set<String> roles) {
        String superRole = PrivilegeManagementImpl.superRole();
        if (superRole != null) {
            if (roles.stream().anyMatch(superRole::equalsIgnoreCase)) {
                return CompletableFuture.failedFuture(new RoleValidationException("Cannot revoke privileges from the super role: " + superRole));
            }
        }
        return this.authorizer.authorizeThenCompose(Action.REVOKE_PRIVILEGE, () -> this.privilegeGrantsStore.revoke(privileges, roles).thenAccept(PrivilegeManagementImpl::processOperationResult));
    }

    @Override
    public CompletableFuture<Void> revokeAsync(PrivilegeAlias privilegeAlias, Set<String> roles) {
        String superRole = PrivilegeManagementImpl.superRole();
        if (superRole != null) {
            if (roles.stream().anyMatch(superRole::equalsIgnoreCase)) {
                return CompletableFuture.failedFuture(new RoleValidationException("Cannot revoke privileges from the super role: " + superRole));
            }
        }
        return this.authorizer.authorizeThenCompose(Action.REVOKE_PRIVILEGE, () -> this.privilegeGrantsStore.revoke(privilegeAlias.toPrivileges(), roles).thenAccept(PrivilegeManagementImpl::processOperationResult));
    }

    private static void processOperationResult(OperationResultContainer<AssignmentOperationResult> or) {
        switch (or.result()) {
            case SUCCESS: {
                return;
            }
            case ROLE_NOT_FOUND: {
                String message = or.value().formatError();
                LOG.info(message, new Object[0]);
                throw RoleNotFoundException.fromMessage(message);
            }
        }
        throw new IllegalStateException("Unexpected operation result type: " + or);
    }

    private static String superRole() {
        return "system";
    }
}

