/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.pitr.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesFactory;
import org.gridgain.internal.pitr.message.PointInTimeRecoveryMessagesTypeInfos;
import org.gridgain.internal.pitr.message.StateRequestMessage;
import org.gridgain.internal.pitr.message.StateRequestMessageBuilder;

class StateRequestMessageDeserializer
implements MessageDeserializer<StateRequestMessage> {
    private final StateRequestMessageBuilder msg;

    StateRequestMessageDeserializer(PointInTimeRecoveryMessagesFactory messageFactory) {
        this.msg = messageFactory.stateRequestMessage();
    }

    @Override
    public Class<StateRequestMessage> klass() {
        return StateRequestMessage.class;
    }

    @Override
    public StateRequestMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PointInTimeRecoveryMessagesTypeInfos.stateRequestMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readUuid("operationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.operationId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(StateRequestMessage.class);
    }
}

