/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.ml;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.ml.IgniteMl;
import org.gridgain.ml.model.MlBatchJobParameters;
import org.gridgain.ml.model.MlColocatedJobParameters;
import org.gridgain.ml.model.MlSimpleJobParameters;
import org.gridgain.ml.model.MlSqlJobParameters;

public class LicensedIgniteMl
implements IgniteMl,
Wrapper {
    private final IgniteMl ml;
    private final LicenseFeatureChecker licenseChecker;

    public LicensedIgniteMl(IgniteMl ml, LicenseFeatureChecker licenseChecker) {
        this.ml = ml;
        this.licenseChecker = licenseChecker;
    }

    @Override
    public <I, O> O predict(MlSimpleJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predict(jobParams);
    }

    @Override
    public <I, O> CompletableFuture<O> predictAsync(MlSimpleJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictAsync(jobParams);
    }

    @Override
    public <I, O> List<O> batchPredict(MlBatchJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.batchPredict(jobParams);
    }

    @Override
    public <I, O> CompletableFuture<List<O>> batchPredictAsync(MlBatchJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.batchPredictAsync(jobParams);
    }

    @Override
    public <O> List<O> predictFromSql(MlSqlJobParameters jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictFromSql(jobParams);
    }

    @Override
    public <O> CompletableFuture<List<O>> predictFromSqlAsync(MlSqlJobParameters jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictFromSqlAsync(jobParams);
    }

    @Override
    public <I, O> O predictColocated(MlColocatedJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictColocated(jobParams);
    }

    @Override
    public <I, O> CompletableFuture<O> predictColocatedAsync(MlColocatedJobParameters<I> jobParams) {
        this.licenseChecker.checkFeature(LicenseFeature.ML_INFERENCE);
        return this.ml.predictColocatedAsync(jobParams);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.ml, classToUnwrap);
    }
}

