/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.lang.GridgainErrorGroups;

public class MissingRequiredFeaturesException
extends IgniteInternalException {
    public MissingRequiredFeaturesException(Set<LicenseFeature> features) {
        super(GridgainErrorGroups.License.MISSING_REQUIRED_FEATURES, MissingRequiredFeaturesException.message(features));
    }

    public MissingRequiredFeaturesException(String message) {
        super(GridgainErrorGroups.License.MISSING_REQUIRED_FEATURES, message);
    }

    public static String message(Set<LicenseFeature> features) {
        return IgniteStringFormatter.format("License violation detected: {} not allowed by the license", MissingRequiredFeaturesException.toString(features));
    }

    private static String toString(Set<LicenseFeature> features) {
        if (features.size() == 1) {
            return CollectionUtils.first(features).name() + " is";
        }
        return features.stream().map(Enum::name).sorted().collect(Collectors.joining(", ", "[", "]")) + " are";
    }
}

