/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.license;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.license.HoconLicenseField;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.license.MissingRequiredFeaturesException;
import org.gridgain.internal.license.event.LicenseUpdateEventParameters;

public class LicenseFeatureCheckerImpl
implements LicenseFeatureChecker,
EventListener<LicenseUpdateEventParameters> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Set<LicenseFeature> enabledFeatures = EnumSet.noneOf(LicenseFeature.class);

    @Override
    public Set<LicenseFeature> enabledFeatures() {
        this.readWriteLock.readLock().lock();
        try {
            Set<LicenseFeature> set = Set.copyOf(this.enabledFeatures);
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public CompletableFuture<Boolean> notify(LicenseUpdateEventParameters parameters) {
        this.readWriteLock.writeLock().lock();
        try {
            Set<LicenseFeature> licenseFeatures = parameters.license().field(HoconLicenseField.FEATURES);
            this.enabledFeatures = licenseFeatures == null ? Set.of() : licenseFeatures;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return CompletableFutures.falseCompletedFuture();
    }

    @Override
    public void checkFeature(LicenseFeature feature) {
        this.readWriteLock.readLock().lock();
        try {
            if (!this.enabledFeatures.contains((Object)feature)) {
                throw new MissingRequiredFeaturesException(Collections.singleton(feature));
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAllFeature(Set<LicenseFeature> features) {
        this.readWriteLock.readLock().lock();
        try {
            EnumSet<LicenseFeature> deniedFeatures = EnumSet.noneOf(LicenseFeature.class);
            for (LicenseFeature reqFeature : features) {
                if (this.enabledFeatures.contains((Object)reqFeature)) continue;
                deniedFeatures.add(reqFeature);
            }
            if (!deniedFeatures.isEmpty()) {
                throw new MissingRequiredFeaturesException(deniedFeatures);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void checkAnyFeature(Set<LicenseFeature> features) {
        this.readWriteLock.readLock().lock();
        try {
            for (LicenseFeature reqFeature : features) {
                if (!this.enabledFeatures.contains((Object)reqFeature)) continue;
                return;
            }
            throw new MissingRequiredFeaturesException(features);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

