/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.encryption.reencryption;

import java.io.IOException;
import java.util.HashMap;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.gridgain.internal.encryption.reencryption.ReencryptionStatus;

public class ReencryptionStatusSerializer
extends VersionedSerializer<ReencryptionStatus> {
    public static final ReencryptionStatusSerializer INSTANCE = new ReencryptionStatusSerializer();

    @Override
    protected void writeExternalData(ReencryptionStatus status, IgniteDataOutput out) throws IOException {
        out.writeInt(status.keyId());
        out.writeInt(status.state().ordinal());
        out.writeMap(status.partitionToIndex(), IntReaderWriter.INSTANCE, IntReaderWriter.INSTANCE);
        out.writeMap(status.partitionToPageCount(), IntReaderWriter.INSTANCE, IntReaderWriter.INSTANCE);
    }

    @Override
    protected ReencryptionStatus readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int keyId = in.readInt();
        int stateOrdinal = in.readInt();
        HashMap partitionToIndex = in.readMap(HashMap::new, IntReaderWriter.INSTANCE, IntReaderWriter.INSTANCE);
        HashMap partitionToPageCount = in.readMap(HashMap::new, IntReaderWriter.INSTANCE, IntReaderWriter.INSTANCE);
        return new ReencryptionStatus(partitionToIndex, partitionToPageCount, ReencryptionStatus.State.values()[stateOrdinal], keyId);
    }

    private static final class IntReaderWriter
    implements IgniteDataOutput.ObjectWriter<Integer>,
    IgniteDataInput.ObjectReader<Integer> {
        private static final IntReaderWriter INSTANCE = new IntReaderWriter();

        private IntReaderWriter() {
        }

        @Override
        public void write(Integer obj, IgniteDataOutput out) throws IOException {
            out.writeInt(obj);
        }

        @Override
        public Integer read(IgniteDataInput in) throws IOException {
            return in.readInt();
        }
    }
}

