/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dcr.message;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.gridgain.internal.dcr.LocalReplicationManager;
import org.gridgain.internal.dcr.Replication;
import org.gridgain.internal.dcr.message.DcrMessageTypes;
import org.gridgain.internal.dcr.message.ReplicationNodeInfo;
import org.gridgain.internal.dcr.message.ReplicationStatusRequest;
import org.gridgain.internal.dcr.message.ReplicationStatusRequestImpl;
import org.gridgain.internal.dcr.message.ReplicationStatusResponse;
import org.gridgain.internal.dcr.message.ReplicationStatusResponseImpl;
import org.jetbrains.annotations.Nullable;

public class DcrMessaging {
    private static final long NETWORK_TIMEOUT_MILLIS = 10000L;
    private final MessagingService messagingService;
    private final TopologyService topologyService;
    private final LocalReplicationManager localReplicationManager;

    public DcrMessaging(LocalReplicationManager localReplicationManager, MessagingService messagingService, TopologyService topologyService) {
        this.messagingService = messagingService;
        this.topologyService = topologyService;
        this.localReplicationManager = localReplicationManager;
    }

    public void start() {
        this.messagingService.addMessageHandler(DcrMessageTypes.class, (message, sender, correlationId) -> {
            assert (correlationId != null);
            this.processRequest(message, sender, correlationId);
        });
    }

    public CompletableFuture<@Nullable ReplicationNodeInfo> status(String replicationName, String nodeName) {
        return this.topologyService.allMembers().stream().filter(node -> node.name().equals(nodeName)).findFirst().map(clusterNode -> this.replicationNodeInfoAsync((InternalClusterNode)clusterNode, replicationName)).orElse(CompletableFutures.nullCompletedFuture());
    }

    private CompletableFuture<@Nullable ReplicationNodeInfo> replicationNodeInfoAsync(InternalClusterNode clusterNode, String replicationName) {
        ReplicationStatusRequest request = ReplicationStatusRequestImpl.builder().replicationName(replicationName).build();
        return this.messagingService.invoke(clusterNode, (NetworkMessage)request, 10000L).thenCompose(networkMessage -> DcrMessaging.infoFromReplicationStatusResponse((ReplicationStatusResponse)networkMessage));
    }

    private void processRequest(NetworkMessage message, InternalClusterNode sender, long correlationId) {
        if (message instanceof ReplicationStatusRequest) {
            this.processReplicationStatusRequest((ReplicationStatusRequest)message, sender, correlationId);
        }
    }

    private void processReplicationStatusRequest(ReplicationStatusRequest request, InternalClusterNode sender, long correlationId) {
        Replication replication = this.localReplicationManager.replication(request.replicationName());
        if (replication != null) {
            this.sendReplicationStatusResponse(replication.replicationNodeInfo(), sender, correlationId);
        } else {
            this.sendReplicationStatusResponse(new ReplicationNodeInfo(0), sender, correlationId);
        }
    }

    private void sendReplicationStatusResponse(ReplicationNodeInfo status, InternalClusterNode sender, Long correlationId) {
        ReplicationStatusResponse replicationStatusResponse = ReplicationStatusResponseImpl.builder().progress(status.progress()).build();
        this.messagingService.respond(sender, (NetworkMessage)replicationStatusResponse, (long)correlationId);
    }

    private static CompletableFuture<@Nullable ReplicationNodeInfo> infoFromReplicationStatusResponse(ReplicationStatusResponse replicationStatusResponse) {
        return CompletableFuture.completedFuture(new ReplicationNodeInfo(replicationStatusResponse.progress()));
    }
}

