/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.user.ListUsersCall;
import org.gridgain.internal.cli.call.rbac.user.ListUsersCallInput;
import org.gridgain.internal.cli.decorators.UserListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List users"})
public class UserListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--role"}, description={"Filter by role name"})
    private String role;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListUsersCall listUsersCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.listUsersCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list users")).print(new UserListDecorator(this.plain)));
    }

    private ListUsersCallInput input(String clusterUrl) {
        return ListUsersCallInput.builder().clusterUrl(clusterUrl).filterByRoleName(this.role).build();
    }
}

