/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.user.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.user.CreateUserReplCall;
import org.gridgain.internal.cli.call.rbac.user.User;
import org.gridgain.internal.cli.call.rbac.user.UserCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create new user if not exists"})
public class UserCreateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(description={"Username"})
    private String username;
    @CommandLine.Option(names={"--password"}, description={"Password"})
    private String password;
    @Inject
    private CreateUserReplCall createUserCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.createUserCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot create user")).print());
    }

    private UserCallInput input(String clusterUrl) {
        return UserCallInput.builder().clusterUrl(clusterUrl).user(User.builder().username(this.username).password(this.password).build()).build();
    }
}

