/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.delete;

import jakarta.inject.Inject;
import java.util.UUID;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.snapshot.SnapshotDeleteCall;
import org.gridgain.internal.cli.call.snapshot.SnapshotDeleteCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Deletes a snapshot"})
public class SnapshotDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--id"}, description={"ID of the snapshot"}, required=true)
    private UUID snapshotId;
    @Inject
    private SnapshotDeleteCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete snapshot")).print());
    }

    private SnapshotDeleteCallInput buildCallInput(String clusterUrl) {
        return SnapshotDeleteCallInput.builder().clusterUrl(clusterUrl).snapshotId(this.snapshotId).build();
    }
}

