/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.sink.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.cdc.sink.DeleteSinkCall;
import org.gridgain.internal.cli.call.cdc.sink.SinkNameCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"CDC sink delete command."})
public class CdcSinkDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC sink."})
    private String name;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private DeleteSinkCall deleteSinkCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.deleteSinkCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete sink")).print());
    }

    private SinkNameCallInput input(String url) {
        return SinkNameCallInput.builder().clusterUrl(url).name(this.name).build();
    }
}

