/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.sink;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.rest.client.model.SinkType;
import org.gridgain.internal.cli.call.cdc.sink.SinkCallInput;
import org.gridgain.internal.cli.call.cdc.sink.UpdateSinkCall;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"CDC sink update command."})
public class CdcSinkUpdateCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @Inject
    private UpdateSinkCall updateSinkCall;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC sink."})
    private String name;
    @CommandLine.Option(required=true, names={"--type"}, description={"Type of the CDC sink."})
    private SinkType type;
    @CommandLine.Option(names={"--parameters"}, description={"Comma-separated key-value pairs of parameters for the sink. For example: 'param1=value1,param2=value2'. If not set, then default parameters will be used."})
    private Map<String, Object> parameters;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.updateSinkCall).inputProvider(() -> SinkCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).name(this.name).type(this.type).parameters(this.parameters).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot update sink")));
    }
}

