/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.replication;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.rest.client.model.ReplicationMode;
import org.gridgain.internal.cli.call.cdc.replication.CreateCdcReplicationCallInput;
import org.gridgain.internal.cli.call.cdc.replication.CreateReplicationCall;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"CDC replication create command."})
public class CdcReplicationCreateCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC replication."})
    private String name;
    @CommandLine.Option(required=true, names={"--sink"}, description={"Name of the CDC sink to use for replication. If not set, then the first sink will be used."})
    private String sinkName;
    @CommandLine.Option(required=true, names={"--source"}, description={"Name of the CDC source to use for replication. If not set, then the first source will be used."})
    private String sourceName;
    @CommandLine.Option(names={"--mode"}, description={"Replication mode. Possible values: 'ALL', 'NEW_DATA'. If not set, then 'ALL' mode will be used."})
    private ReplicationMode mode;
    @CommandLine.Option(names={"--execution-nodes"}, description={"Names of nodes (use comma-separated list of node names '--nodes node1, node2' to specify more than one node) that will host the CDC replication. If not set, then a random node will be used."}, split=",")
    private List<String> executionNodes = List.of();
    @Inject
    private CreateReplicationCall createReplicationCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.createReplicationCall).inputProvider(() -> CreateCdcReplicationCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).name(this.name).sinkName(this.sinkName).sourceName(this.sourceName).mode(this.mode).executionNodes(this.executionNodes).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot create replication")));
    }
}

