/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands;

public enum GridGainOptions {
    USERNAME("--username", "--username", "Username"),
    PASSWORD("--password", "--password", "Password"),
    ROLE("--role", "-r", "Role name"),
    TO_USER("--to", "--to", "To username"),
    TO_ROLE("--to", "--to", "To role name"),
    FROM_USER("--from", "--from", "From username"),
    FROM_ROLE("--from", "--from", "From role"),
    ACTION("--action", "--action", "Action"),
    ON("--on", "--on", "Object"),
    REPLICATION_NODES("--replication-nodes", "--replication-nodes", "Comma-separated replication nodes names, worker node will be chosen from the list of replication nodes."),
    CDC_REPLICATION_NODES("--execution-nodes", "--execution-nodes", "Names of nodes (use comma-separated list of node names '--nodes node1, node2' to specify more than one node) that will host the CDC replication. If not set, then a random node will be used.");

    private final String fullName;
    private final String shortName;
    private final String description;

    private GridGainOptions(String fullName, String shortName, String description) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.description = description;
    }

    public String fullName() {
        return this.fullName;
    }

    public String shortName() {
        return this.shortName;
    }

    public String description() {
        return this.description;
    }

    public static final class Constants {
        public static final String USERNAME_OPTION = "--username";
        public static final String USERNAME_OPTION_DESC = "Username";
        public static final String PASSWORD_OPTION = "--password";
        public static final String PASSWORD_OPTION_DESC = "Password";
        public static final String ROLE_OPTION = "--role";
        public static final String ROLE_OPTION_SHORT = "-r";
        public static final String ROLE_OPTION_DESC = "Role name";
        public static final String TO_OPTION = "--to";
        public static final String TO_USERNAME_OPTION_DESC = "To username";
        public static final String TO_ROLE_OPTION_DESC = "To role name";
        public static final String FROM_OPTION = "--from";
        public static final String FROM_USER_OPTION_DESC = "From username";
        public static final String FROM_ROLE_OPTION_DESC = "From role";
        public static final String WITH_ROLES_OPTION = "--with-roles";
        public static final String WITH_ROLES_OPTION_DESC = "Show user with assigned roles";
        public static final String USER_OPTION = "--user";
        public static final String WITH_USERS_OPTION = "--with-users";
        public static final String WITH_USERS_OPTION_DESC = "Show role with assigned users";
        public static final String WITH_PRIVILEGES_OPTION = "--with-privileges";
        public static final String WITH_PRIVILEGES_OPTION_DESC = "Show role with granted privileges";
        public static final String ROLE_NAME_PARAMETER_DESC = "Role name";
        public static final String FILTER_BY_USER_OPTION_DESC = "Filter by user name";
        public static final String FILTER_BY_ROLE_OPTION_DESC = "Filter by role name";
        public static final String USERNAME_PARAMETER_DESC = "Username";
        public static final String ACTION_OPTION = "--action";
        public static final String ACTION_OPTION_DESC = "Action";
        public static final String ON_OPTION = "--on";
        public static final String ON_OPTION_DESC = "Object";
        public static final String WITH_REVOKE_OPTION_SHORT = "-r";
        public static final String WITH_REVOKE_OPTION = "--with-revoke";
        public static final String WITH_REVOKE_OPTION_DESC = "Revoke connected roles and users.";
        public static final String REPLICATION_NAME_PARAMETER_DESC = "Replication name.";
        public static final String SCHEMA_OPTION = "--schema";
        public static final String SCHEMA_OPTION_DESC = "Schema name. For example, PUBLIC.";
        public static final String SOURCE_CLUSTER_ADDRESS_OPTION = "--source-cluster-address";
        public static final String SOURCE_CLUSTER_ADDRESS_OPTION_DESC = "Comma-separated list of client addresses of the cluster that is a source cluster for the replication. Example: localhost:10800,localhost:10801";
        public static final String REPLICATION_NAME_OPTION = "--name";
        public static final String REPLICATION_NAME_OPTION_DESC = "The unique name of the replication. Should be without whitespaces.";
        public static final String FLUSH_POINT_OPTION = "--flush-point";
        public static final String FLUSH_POINT_OPTION_DESC = "The flush point is a timestamp in the ISO-8601 format that is used to determine whether the replicated data is sufficient. After setting a flush point, replication will be considered completed at the moment when all replicated tables have all received data older than this flush point. Example: 1970-01-01T00:00:00Z.";
        public static final String REPLICATION_NODES_OPTION = "--replication-nodes";
        public static final String REPLICATION_NODES_OPTION_DESC = "Comma-separated replication nodes names, worker node will be chosen from the list of replication nodes.";
        public static final String KEYSTORE_PATH_OPTION = "--keyStorePath";
        public static final String KEYSTORE_PASSWORD_OPTION = "--keyStorePassword";
        public static final String TRUSTSTORE_PATH_OPTION = "--trustStorePath";
        public static final String TRUSTSTORE_PASSWORD_OPTION = "--trustStorePassword";
        public static final String LICENSE_FILE_OPTION = "--license";
        public static final String LICENSE_FILE_PARAMETER_DESC = "License file.";
        public static final String VERSION_OPTION = "--version";
        public static final String VERSION_OPTION_DESC = "New version. For example, 9.1.1";
        public static final String CDC_SOURCE_NAME_OPTION = "--name";
        public static final String CDC_SOURCE_NAME_OPTION_DESC = "Name of the CDC source.";
        public static final String CDC_SOURCE_TYPE_OPTION = "--type";
        public static final String CDC_SOURCE_TYPE_OPTION_DESC = "Type of the CDC source.";
        public static final String CDC_SOURCE_PARAMETERS_OPTION = "--parameters";
        public static final String CDC_SOURCE_PARAMETERS_OPTION_DESC = "Comma-separated key-value pairs of parameters for the source. For example: 'param1=value1,param2=value2'. If not set, then default parameters will be used.";
        public static final String CDC_SOURCE_TABLES_OPTION = "--tables";
        public static final String CDC_SOURCE_TABLES_OPTION_DESC = "Comma-separated fully-qualified table names that will be parts of the source.";
        public static final String CDC_SINK_NAME_OPTION = "--name";
        public static final String CDC_SINK_NAME_OPTION_DESC = "Name of the CDC sink.";
        public static final String CDC_SINK_TYPE_OPTION = "--type";
        public static final String CDC_SINK_TYPE_OPTION_DESC = "Type of the CDC sink.";
        public static final String CDC_SINK_PARAMETERS_OPTION = "--parameters";
        public static final String CDC_SINK_PARAMETERS_OPTION_DESC = "Comma-separated key-value pairs of parameters for the sink. For example: 'param1=value1,param2=value2'. If not set, then default parameters will be used.";
        public static final String CDC_SINK_CREATE_TABLE_IF_NOT_EXISTS_OPTION = "--create-table-if-not-exists";
        public static final String CDC_SINK_CREATE_TABLE_IF_NOT_EXISTS_OPTION_DESC = "Create table if not exists. If not set, then the table must already exist in the sink.";
        public static final String CDC_REPLICATION_NAME_OPTION = "--name";
        public static final String CDC_REPLICATION_NAME_OPTION_DESC = "Name of the CDC replication.";
        public static final String CDC_REPLICATION_MODE_OPTION = "--mode";
        public static final String CDC_REPLICATION_MODE_OPTION_DESC = "Replication mode. Possible values: 'ALL', 'NEW_DATA'. If not set, then 'ALL' mode will be used.";
        public static final String CDC_REPLICATION_SOURCE_NAME_OPTION = "--source";
        public static final String CDC_REPLICATION_SOURCE_NAME_OPTION_DESC = "Name of the CDC source to use for replication. If not set, then the first source will be used.";
        public static final String CDC_REPLICATION_SINK_NAME_OPTION = "--sink";
        public static final String CDC_REPLICATION_SINK_NAME_OPTION_DESC = "Name of the CDC sink to use for replication. If not set, then the first sink will be used.";
        public static final String CDC_REPLICATION_NODES_OPTION = "--execution-nodes";
        public static final String CDC_REPLICATION_NODES_OPTION_DESC = "Names of nodes (use comma-separated list of node names '--nodes node1, node2' to specify more than one node) that will host the CDC replication. If not set, then a random node will be used.";
    }
}

