/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.snapshot;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.table.Table;
import org.apache.ignite3.rest.client.api.SnapshotManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.SnapshotListItem;
import org.gridgain.internal.cli.call.snapshot.SnapshotListCallInput;
import org.gridgain.internal.cli.call.snapshot.SnapshotListCallUtils;

@Singleton
public class SnapshotListCall
implements Call<SnapshotListCallInput, Table> {
    private final ApiClientFactory clientFactory;

    public SnapshotListCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<Table> execute(SnapshotListCallInput input) {
        SnapshotManagementApi client = new SnapshotManagementApi(this.clientFactory.getClient(input.clusterUrl()));
        try {
            List<SnapshotListItem> list = SnapshotListCall.getList(client, input);
            Table<String> resultTable = new Table<String>(SnapshotListCallUtils.outputHeaders(input), SnapshotListCallUtils.outputContent(input, list));
            return DefaultCallOutput.success(resultTable);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }

    private static List<SnapshotListItem> getList(SnapshotManagementApi client, SnapshotListCallInput input) throws ApiException {
        return client.getList(input.isShowNodeNames(), input.isShowTableNames(), input.isShowSnapshotUri(), input.snapshotUriName());
    }
}

