/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.assignments;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RoleAssignmentsApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.RoleAssignment;
import org.gridgain.internal.cli.call.rbac.assignments.AssignRevokeCallInput;

@Singleton
public class RevokeRoleCall
implements Call<AssignRevokeCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public RevokeRoleCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(AssignRevokeCallInput input) {
        String clusterUrl = input.url();
        try {
            this.revokeRest(clusterUrl, input.roleNames(), input.usernames());
            return DefaultCallOutput.success(RevokeRoleCall.formatSuccess(input.roleNames(), input.usernames()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private void revokeRest(String clusterUrl, List<String> roleNames, List<String> usernames) throws ApiException {
        new RoleAssignmentsApi(this.apiClientFactory.getClient(clusterUrl)).revokeRoles(new RoleAssignment().roleNames(roleNames).usernames(usernames));
    }

    private static String formatSuccess(List<String> roleNames, List<String> usernames) {
        return (roleNames.size() == 1 ? "Role " : "Roles ") + String.join((CharSequence)",", roleNames) + " revoked from " + (usernames.size() == 1 ? "user " : "users ") + String.join((CharSequence)",", usernames);
    }
}

