/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.source;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Source;
import org.gridgain.internal.cli.call.cdc.source.SourceCallInput;
import org.gridgain.internal.cli.core.exception.AlreadyExistsException;

@Singleton
public class CreateSourceCall
implements Call<SourceCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public CreateSourceCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(SourceCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).createSource(new Source().type(input.type()).name(input.name()).parameters(input.params()).tables(input.tables()));
            return DefaultCallOutput.success("Source " + input.name() + " created.");
        }
        catch (IllegalArgumentException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
        catch (ApiException e) {
            if (ClusterNotInitializedExceptionHandler.isClusterNotInitialized(e)) {
                return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
            }
            if (e.getCode() == 409) {
                return DefaultCallOutput.failure(new AlreadyExistsException(e));
            }
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

