/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table;

import java.util.Objects;
import org.apache.ignite3.table.ContinuousQueryWatermark;
import org.apache.ignite3.table.ReadTimestampAccessor;
import org.apache.ignite3.tx.Transaction;

public class ContinuousQueryTransactionWatermark
implements ContinuousQueryWatermark {
    private static final long serialVersionUID = 4816921912590358491L;
    private final transient Transaction tx;
    private final boolean after;
    private final long readTimestamp;

    ContinuousQueryTransactionWatermark(Transaction tx, boolean after) {
        Objects.requireNonNull(tx, "tx can't be null");
        if (!tx.isReadOnly()) {
            throw new IllegalArgumentException("Transaction must be read-only to create a ContinuousQueryWatermark.");
        }
        this.tx = tx;
        this.after = after;
        if (!(tx instanceof ReadTimestampAccessor)) {
            throw new IllegalArgumentException("Unsupported transaction type, can't get readTimestamp: " + tx.getClass());
        }
        this.readTimestamp = ((ReadTimestampAccessor)((Object)tx)).readTimestampLong();
    }

    @Deprecated(forRemoval=true)
    public Transaction transaction() {
        return this.tx;
    }

    public boolean isAfter() {
        return this.after;
    }

    long readTimestampLong() {
        return this.readTimestamp;
    }
}

