/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.util.Ints;
import org.apache.ignite3.raft.jraft.util.Platform;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.StringUtils;
import org.apache.ignite3.raft.jraft.util.SystemPropertyUtil;
import org.apache.ignite3.raft.jraft.util.ThreadPoolMetricSet;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private static final IgniteLogger LOG = Loggers.forClass(Utils.class);
    private static final int CPUS = SystemPropertyUtil.getInt("jraft.available_processors", Runtime.getRuntime().availableProcessors());
    public static final int MIN_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.min", Utils.cpus());
    public static final int MAX_CLOSURE_EXECUTOR_POOL_SIZE = SystemPropertyUtil.getInt("jraft.closure.threadpool.size.max", Math.max(100, Utils.cpus() * 5));
    public static final int APPEND_ENTRIES_THREADS_POOL_SIZE = SystemPropertyUtil.getInt("jraft.append.entries.threads.send", Math.max(16, Ints.findNextPositivePowerOfTwo(Utils.cpus() * 2)));
    public static final int MAX_APPEND_ENTRIES_TASKS_PER_THREAD = SystemPropertyUtil.getInt("jraft.max.append.entries.tasks.per.thread", 32768);
    public static final boolean USE_MPSC_SINGLE_THREAD_EXECUTOR = SystemPropertyUtil.getBoolean("jraft.use.mpsc.single.thread.executor", true);
    private static final Pattern GROUP_ID_PATTER = Pattern.compile("^[0-9a-zA-Z][a-zA-Z0-9\\-_]*$");
    public static final int RAFT_DATA_BUF_SIZE = SystemPropertyUtil.getInt("jraft.byte_buf.size", 1024);
    public static final int MAX_COLLECTOR_SIZE_PER_THREAD = SystemPropertyUtil.getInt("jraft.max_collector_size_per_thread", 256);
    public static final int MAX_COLLECTOR_SIZE_PER_SERVER = SystemPropertyUtil.getInt("jraft.max_collector_size_per_server", 256);
    public static final String IP_ANY = "0.0.0.0";
    public static final String IPV6_START_MARK = "[";
    public static final String IPV6_END_MARK = "]";
    private static final int IPV6_ADDRESS_LENGTH = 16;

    public static void verifyGroupId(String groupId) {
        if (StringUtils.isBlank(groupId)) {
            throw new IllegalArgumentException("Blank groupId");
        }
        if (!GROUP_ID_PATTER.matcher(groupId).matches()) {
            throw new IllegalArgumentException("Invalid group id, it should be started with number or character 'a'-'z' or 'A'-'Z',and followed with numbers, english alphabet, '-' or '_'. ");
        }
    }

    public static void registerClosureExecutorMetrics(String name, MetricRegistry reg, ThreadPoolExecutor executor) {
        reg.register(name, (Metric)new ThreadPoolMetricSet(executor));
    }

    public static void runClosure(Closure done, Status status) {
        if (done != null) {
            done.run(status);
        }
    }

    public static Future<?> runClosureInThread(ExecutorService executor, Closure done) {
        if (done == null) {
            return null;
        }
        return Utils.runClosureInThread(executor, done, Status.OK());
    }

    public static Future<?> runInThread(ExecutorService executor, Runnable runnable) {
        return executor.submit(runnable);
    }

    public static void runInThread(Executor executor, Runnable runnable) {
        executor.execute(runnable);
    }

    public static <V> Future<V> runInThread(ExecutorService executor, Callable<V> runnable) {
        return executor.submit(runnable);
    }

    public static Future<?> runClosureInThread(ExecutorService executor, final Closure done, final Status status) {
        if (done == null) {
            return null;
        }
        return Utils.runInThread(executor, new Runnable(){

            @Override
            public void run() {
                try {
                    done.run(status);
                }
                catch (Throwable t) {
                    LOG.error("Fail to run done closure", t);
                }
            }
        });
    }

    public static void runClosureInExecutor(Executor executor, Closure done, Status status) {
        assert (executor != null);
        if (done == null) {
            return;
        }
        executor.execute(() -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure.", t);
            }
        });
    }

    public static void runClosureInExecutor(Executor executor, Closure done) {
        Utils.runClosureInExecutor(executor, done, Status.OK());
    }

    public static int closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return 0;
        }
        try {
            closeable.close();
            return 0;
        }
        catch (IOException e) {
            LOG.error("Fail to close {}.", closeable, e);
            return RaftError.EIO.getNumber();
        }
    }

    public static int cpus() {
        return CPUS;
    }

    public static long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static ByteBuffer expandByteBuffer(ByteBuffer buf) {
        return Utils.expandByteBufferAtLeast(buf, RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer allocate(int size) {
        return ByteBuffer.allocate(size);
    }

    public static ByteBuffer allocate() {
        return Utils.allocate(RAFT_DATA_BUF_SIZE);
    }

    public static ByteBuffer expandByteBufferAtLeast(ByteBuffer buf, int minLength) {
        int newCapacity = minLength > RAFT_DATA_BUF_SIZE ? minLength : RAFT_DATA_BUF_SIZE;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static ByteBuffer expandByteBufferAtMost(ByteBuffer buf, int maxLength) {
        int newCapacity = maxLength > RAFT_DATA_BUF_SIZE || maxLength <= 0 ? RAFT_DATA_BUF_SIZE : maxLength;
        ByteBuffer newBuf = ByteBuffer.allocate(buf.capacity() + newCapacity);
        buf.flip();
        newBuf.put(buf);
        return newBuf;
    }

    public static long monotonicMs() {
        return IgniteUtils.monotonicMs();
    }

    public static long nowMs() {
        return System.currentTimeMillis();
    }

    public static long monotonicUs() {
        return TimeUnit.NANOSECONDS.toMicros(System.nanoTime());
    }

    public static long monotonicMsAfter(long timeoutMillis) {
        if (timeoutMillis == Long.MAX_VALUE || timeoutMillis < 0L) {
            return Long.MAX_VALUE;
        }
        long now = Utils.monotonicMs();
        if (timeoutMillis > Long.MAX_VALUE - now) {
            return Long.MAX_VALUE;
        }
        return now + timeoutMillis;
    }

    public static byte[] getBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static <T> T withLockObject(T obj) {
        return Requires.requireNonNull(obj, "obj");
    }

    public static boolean atomicMoveFile(File source, File target, boolean sync) throws IOException {
        boolean success;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(target, "target");
        boolean bl = success = IgniteUtils.atomicMoveFile(source.toPath(), target.toPath(), LOG) != null;
        if (success && sync) {
            File dir = target.getParentFile();
            Utils.fsync(dir);
        }
        return success;
    }

    public static void fsync(File file) throws IOException {
        boolean isDir = file.isDirectory();
        if (isDir && Platform.isWindows()) {
            return;
        }
        try (FileChannel fc = FileChannel.open(file.toPath(), isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            fc.force(true);
        }
    }

    public static void unmap(MappedByteBuffer cb) {
        block5: {
            boolean isOldJDK = System.getProperty("java.specification.version", "99").startsWith("1.");
            try {
                Class<?> unsafeClass;
                if (isOldJDK) {
                    Method cleaner = cb.getClass().getMethod("cleaner", new Class[0]);
                    cleaner.setAccessible(true);
                    Method clean = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                    clean.setAccessible(true);
                    clean.invoke(cleaner.invoke((Object)cb, new Object[0]), new Object[0]);
                    break block5;
                }
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception ex) {
                    unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
                }
                Method clean = unsafeClass.getMethod("invokeCleaner", ByteBuffer.class);
                clean.setAccessible(true);
                Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafeField.setAccessible(true);
                Object theUnsafe = theUnsafeField.get(null);
                clean.invoke(theUnsafe, cb);
            }
            catch (Exception ex) {
                LOG.error("Fail to un-mapped segment file.", (Throwable)ex);
            }
        }
    }

    public static String getString(byte[] bs, int off, int len) {
        return new String(bs, off, len, StandardCharsets.UTF_8);
    }

    public static boolean isIPv6(String addr) {
        try {
            return InetAddress.getByName(addr).getAddress().length == 16;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] parsePeerId(String s) {
        if (s.startsWith(IPV6_START_MARK) && StringUtils.containsIgnoreCase(s, IPV6_END_MARK)) {
            String ipv6Addr = s.endsWith(IPV6_END_MARK) ? s : s.substring(0, s.indexOf(IPV6_END_MARK) + 1);
            if (!Utils.isIPv6(ipv6Addr)) {
                throw new IllegalArgumentException("The IPv6 address(\"" + ipv6Addr + "\") is incorrect.");
            }
            String tempString = s.substring(s.indexOf(ipv6Addr) + ipv6Addr.length());
            if (tempString.startsWith(":")) {
                tempString = tempString.substring(1);
            }
            String[] tempArr = StringUtils.splitPreserveAllTokens(tempString, ':');
            String[] result = new String[1 + tempArr.length];
            result[0] = ipv6Addr;
            System.arraycopy(tempArr, 0, result, 1, tempArr.length);
            return result;
        }
        return StringUtils.splitPreserveAllTokens(s, ':');
    }

    public static boolean mkdir(File file) {
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        return file.mkdirs();
    }

    public static int size(@Nullable Collection<?> col) {
        return col == null ? 0 : col.size();
    }
}

