/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;
import org.apache.ignite3.raft.jraft.rpc.TimeoutNowRequestImpl;

class TimeoutNowRequestSerializer
implements MessageSerializer<RpcRequests.TimeoutNowRequest> {
    public static final TimeoutNowRequestSerializer INSTANCE = new TimeoutNowRequestSerializer();

    private TimeoutNowRequestSerializer() {
    }

    @Override
    public boolean writeMessage(RpcRequests.TimeoutNowRequest msg, MessageWriter writer) throws MessageMappingException {
        TimeoutNowRequestImpl message = (TimeoutNowRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.timeoutNowRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)5)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("peerId", message.peerId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeString("serverId", message.serverId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

