/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.raft.ReadCommand;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.ReadActionRequest;
import org.apache.ignite3.raft.jraft.rpc.ReadActionRequestBuilder;

class ReadActionRequestDeserializer
implements MessageDeserializer<ReadActionRequest> {
    private final ReadActionRequestBuilder msg;

    ReadActionRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readActionRequest();
    }

    @Override
    public Class<ReadActionRequest> klass() {
        return ReadActionRequest.class;
    }

    @Override
    public ReadActionRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.readActionRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (ReadCommand)reader.readMessage("command");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.command((ReadCommand)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((String)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("readOnlySafe");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readOnlySafe(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadActionRequest.class);
    }
}

