/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.GetFileRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class GetFileRequestDeserializer
implements MessageDeserializer<RpcRequests.GetFileRequest> {
    private final GetFileRequestBuilder msg;

    GetFileRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.getFileRequest();
    }

    @Override
    public Class<RpcRequests.GetFileRequest> klass() {
        return RpcRequests.GetFileRequest.class;
    }

    @Override
    public RpcRequests.GetFileRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.getFileRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("count");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.count(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("filename");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.filename(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("offset");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.offset(tmp);
                reader.incrementState();
            }
            case 3: {
                boolean tmp = reader.readBoolean("readPartly");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readPartly(tmp);
                reader.incrementState();
            }
            case 4: {
                long tmp = reader.readLong("readerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readerId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.GetFileRequest.class);
    }
}

